/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import com.typesafe.config.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class DigMobHole
implements ProjectileAction {
    static final String CONFIG_KEY = DigMobHole.class.getSimpleName();
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
    final int noHitHoleDepth;
    final int noHitholeHeight;
    final int noHitholeWidth;
    final int holeHeightExpansion;

    public DigMobHole() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.noHitHoleDepth = configuration.getInt(CONFIG_KEY + ".NoHitHoleDepth");
        this.noHitholeHeight = configuration.getInt(CONFIG_KEY + ".NoHitHoleHeight");
        this.noHitholeWidth = configuration.getInt(CONFIG_KEY + ".NoHitHoleWidth");
        this.holeHeightExpansion = configuration.getInt(CONFIG_KEY + ".HitHoleHeightExpansion");
    }

    @Override
    public void execute(EntityThrowable projectile, World world, RayTraceResult movObjPos) {
        CompositeStructure composite = new CompositeStructure();
        if (movObjPos.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK)) {
            BlockPos offset = this.calculatePosition(world, movObjPos);
            this.createVerticalStructure(composite);
            PlayerDirection playerDirection = PlayerDirection.South;
            List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, composite);
            this.repository.addAll(directives);
        }
        if (movObjPos.field_72313_a.equals((Object)RayTraceResult.Type.ENTITY)) {
            Entity entity = movObjPos.field_72308_g;
            AxisAlignedBB aabb = entity.func_174813_aQ();
            BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b - (double)this.holeHeightExpansion, aabb.field_72339_c);
            BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
                double translateY = aabb.field_72337_e - aabb.field_72338_b;
                BlockPos tranlatedPos = pos.func_177963_a(0.0, -translateY, 0.0);
                BlockDirective directive = new BlockDirective(tranlatedPos, Blocks.field_150350_a, false);
                this.repository.add(directive);
            }
        }
    }

    BlockPos calculatePosition(World world, RayTraceResult movObjPos) {
        switch (movObjPos.field_178784_b) {
            case UP: {
                return movObjPos.func_178782_a().func_177984_a();
            }
            case DOWN: {
                return movObjPos.func_178782_a().func_177977_b();
            }
            case SOUTH: {
                return movObjPos.func_178782_a().func_177968_d();
            }
            case NORTH: {
                return movObjPos.func_178782_a().func_177978_c();
            }
            case EAST: {
                return movObjPos.func_178782_a().func_177974_f();
            }
            case WEST: {
                return movObjPos.func_178782_a().func_177976_e();
            }
        }
        return movObjPos.func_178782_a().func_177984_a();
    }

    void createVerticalStructure(CompositeStructure composite) {
        BlockPos offset = new BlockPos(0, -this.noHitHoleDepth, 0);
        BlockPos size = new BlockPos(this.noHitholeWidth, this.noHitholeHeight, this.noHitHoleDepth);
        composite.add(ChildStructure.createAirStructure(offset, size));
    }
}

