/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.projectile.action.ProjectileAction;
import com.typesafe.config.Config;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpawnCreeperArmy
implements ProjectileAction {
    static final String CONFIG_KEY = SpawnCreeperArmy.class.getSimpleName();
    static final float PITCH = 0.0f;
    final int creepers;
    final int spawnSize;

    public SpawnCreeperArmy() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.creepers = configuration.getInt(CONFIG_KEY + ".Creepers");
        this.spawnSize = configuration.getInt(CONFIG_KEY + ".SpawnSize");
    }

    @Override
    public void execute(EntityThrowable projectile, World world, RayTraceResult movObjPos) {
        for (int i = 0; i < this.creepers; ++i) {
            EntityCreeper entity = new EntityCreeper(world);
            Random random = entity.func_70681_au();
            int randomX = random.nextInt(this.spawnSize) - this.spawnSize / 2;
            int randomZ = random.nextInt(this.spawnSize) - this.spawnSize / 2;
            double positionX = projectile.field_70165_t + (double)randomX;
            double positionY = projectile.field_70163_u;
            double positionZ = projectile.field_70161_v + (double)randomZ;
            entity.func_70012_b(positionX, positionY, positionZ, projectile.field_70177_z, 0.0f);
            EntityLivingBase thrower = projectile.func_85052_h();
            TeamRepository teamRepository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
            teamRepository.add(thrower, (EntityLivingBase)entity);
            AiUtils.clearAiTasks((EntityLiving)entity);
            AiUtils.buildCreeperArmyAi(entity, thrower);
            world.func_72838_d((Entity)entity);
        }
    }
}

