/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.projectile.action.ProjectileAction;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpawnKittenArmy
implements ProjectileAction {
    static final String CONFIG_KEY = SpawnKittenArmy.class.getSimpleName();
    static final int CAT_TYPE = 3;
    static final float PITCH = 0.0f;
    final int age;
    final int kittens;
    final int spawnSize;
    final boolean renderCustomName;
    final List<String> names;

    public SpawnKittenArmy() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.age = configuration.getInt(CONFIG_KEY + ".Age");
        this.kittens = configuration.getInt(CONFIG_KEY + ".Kittens");
        this.spawnSize = configuration.getInt(CONFIG_KEY + ".SpawnSize");
        this.renderCustomName = configuration.getBoolean(CONFIG_KEY + ".RenderCustomName");
        this.names = configuration.getStringList(CONFIG_KEY + ".Names");
    }

    @Override
    public void execute(EntityThrowable projectile, World world, RayTraceResult movObjPos) {
        for (int i = 0; i < this.kittens; ++i) {
            EntityOcelot entity = new EntityOcelot(world);
            if (i == 0) {
                entity.func_70873_a(1);
            } else {
                entity.func_70873_a(this.age);
            }
            entity.func_70903_f(true);
            entity.func_70912_b(3);
            EntityLivingBase owner = projectile.func_85052_h();
            entity.func_184754_b(owner.func_110124_au());
            if (owner instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)owner;
                entity.func_146082_f(player);
            }
            Random random = entity.func_70681_au();
            int randomX = random.nextInt(this.spawnSize) - this.spawnSize / 2;
            int randomZ = random.nextInt(this.spawnSize) - this.spawnSize / 2;
            double positionX = projectile.field_70165_t + (double)randomX;
            double positionY = projectile.field_70163_u;
            double positionZ = projectile.field_70161_v + (double)randomZ;
            entity.func_70012_b(positionX, positionY, positionZ, projectile.field_70177_z, 0.0f);
            TeamRepository teamRepository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
            teamRepository.add(owner, (EntityLivingBase)entity);
            AiUtils.clearAiTasks((EntityLiving)entity);
            AiUtils.buildKittenArmyAi(entity, owner);
            if (this.renderCustomName) {
                entity.func_96094_a(this.getKittenName(random, i));
                entity.func_174805_g(true);
            }
            world.func_72838_d((Entity)entity);
        }
    }

    String getKittenName(Random random, int index) {
        if (index == 0) {
            return this.names.get(index);
        }
        int size = this.names.size();
        int randomIndex = random.nextInt(size - 1);
        return this.names.get(randomIndex + 1);
    }
}

