/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.projectile.action.ProjectileAction;
import com.typesafe.config.Config;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpawnSkeletonArmy
implements ProjectileAction {
    static final String CONFIG_KEY = SpawnSkeletonArmy.class.getSimpleName();
    static final float PITCH = 0.0f;
    final int skeletons;
    final int spawnSize;

    public SpawnSkeletonArmy() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.skeletons = configuration.getInt(CONFIG_KEY + ".Skeletons");
        this.spawnSize = configuration.getInt(CONFIG_KEY + ".SpawnSize");
    }

    @Override
    public void execute(EntityThrowable projectile, World world, RayTraceResult movObjPos) {
        for (int i = 0; i < this.skeletons; ++i) {
            EntitySkeleton entity = new EntitySkeleton(world);
            entity.func_184724_a(true);
            Random random = entity.func_70681_au();
            int randomX = random.nextInt(this.spawnSize) - this.spawnSize / 2;
            int randomZ = random.nextInt(this.spawnSize) - this.spawnSize / 2;
            double positionX = projectile.field_70165_t + (double)randomX;
            double positionY = projectile.field_70163_u;
            double positionZ = projectile.field_70161_v + (double)randomZ;
            entity.func_70012_b(positionX, positionY, positionZ, projectile.field_70177_z, 0.0f);
            ItemStack bowStack = new ItemStack((Item)Items.field_151031_f);
            entity.func_184611_a(EnumHand.MAIN_HAND, bowStack);
            ItemStack helmetstack = new ItemStack((Item)Items.field_151161_ac);
            entity.func_184201_a(EntityEquipmentSlot.HEAD, helmetstack);
            EntityLivingBase thrower = projectile.func_85052_h();
            TeamRepository teamRepository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
            teamRepository.add(thrower, (EntityLivingBase)entity);
            AiUtils.clearAiTasks((EntityLiving)entity);
            AiUtils.buildSkeletonArmyAi(entity, thrower);
            world.func_72838_d((Entity)entity);
        }
    }
}

