/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.build.BuildUtils;
import bassebombecraft.item.action.build.tower.StairsMaterial;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.structure.CompositeStructure;
import com.typesafe.config.Config;
import java.util.List;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpawnStairs
implements ProjectileAction {
    static final String CONFIG_KEY = SpawnStairs.class.getSimpleName();
    int duration;

    public SpawnStairs() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.duration = configuration.getInt(CONFIG_KEY + ".Duration");
    }

    @Override
    public void execute(EntityThrowable projectile, World world, RayTraceResult movObjPos) {
        if (movObjPos.field_72308_g == null) {
            EntityLivingBase owner = projectile.func_85052_h();
            int yFeetPosition = EntityUtils.calculateEntityFeetPosititionAsInt(owner);
            BlockPos targetPosition = this.calculatePosition(world, movObjPos);
            int stairsHeight = Math.abs(yFeetPosition - targetPosition.func_177956_o()) + 1;
            BlockPos stairOffset = new BlockPos(0, -stairsHeight, 1 - stairsHeight);
            CompositeStructure composite = new CompositeStructure();
            IBlockState state = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            StairsMaterial stairsMaterial = BuildUtils.createInstance(state, Blocks.field_150390_bg, Blocks.field_150417_aV);
            BuildUtils.addSolidStairUp(stairsHeight, stairsMaterial, composite, stairOffset);
            PlayerDirection playerDirection = EntityUtils.getPlayerDirection(owner);
            BlockPos offset = targetPosition;
            List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, composite);
            for (BlockDirective directive : directives) {
                BlockUtils.setTemporaryBlock(world, directive, this.duration);
            }
            return;
        }
    }

    BlockPos calculatePosition(World world, RayTraceResult movObjPos) {
        switch (movObjPos.field_178784_b) {
            case UP: {
                return movObjPos.func_178782_a().func_177984_a();
            }
            case DOWN: {
                return movObjPos.func_178782_a().func_177977_b();
            }
            case SOUTH: {
                return movObjPos.func_178782_a().func_177968_d();
            }
            case NORTH: {
                return movObjPos.func_178782_a().func_177978_c();
            }
            case EAST: {
                return movObjPos.func_178782_a().func_177974_f();
            }
            case WEST: {
                return movObjPos.func_178782_a().func_177976_e();
            }
        }
        return movObjPos.func_178782_a().func_177984_a();
    }
}

