/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.world;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.StructureInfo;
import bassebombecraft.world.TemplateUtils;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class RandomModStructuresGenerator
implements IWorldGenerator {
    static final String CONFIG_KEY = RandomModStructuresGenerator.class.getSimpleName();
    List<StructureInfo> infos;
    boolean enabled;

    public RandomModStructuresGenerator() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.enabled = configuration.getBoolean(CONFIG_KEY + ".enabled");
        this.infos = ConfigUtils.createStructureInfosFromConfig(CONFIG_KEY + ".structures");
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.enabled) {
            return;
        }
        if (this.infos == null) {
            return;
        }
        if (this.infos.isEmpty()) {
            return;
        }
        int index = random.nextInt(this.infos.size());
        StructureInfo info = this.infos.get(index);
        if (random.nextDouble() > info.getSpawnRate()) {
            return;
        }
        if (!this.generateInThisDimension(world, info)) {
            return;
        }
        if (!this.shouldSpawnInBiome(chunkX, chunkZ, world, info)) {
            return;
        }
        this.generateStructure(random, chunkX, chunkZ, world, info);
    }

    boolean shouldSpawnInBiome(int chunkX, int chunkZ, World world, StructureInfo info) {
        String biome = info.getBiome();
        if (biome == null) {
            return true;
        }
        if (biome.isEmpty()) {
            return true;
        }
        if (biome.equalsIgnoreCase("any")) {
            return true;
        }
        Biome currentBiome = world.func_72959_q().func_180631_a(new BlockPos(chunkX, 0, chunkZ));
        String name = currentBiome.func_185359_l();
        return biome.equalsIgnoreCase(name);
    }

    boolean generateInThisDimension(World world, StructureInfo info) {
        switch (world.field_73011_w.func_186058_p()) {
            case NETHER: {
                return false;
            }
            case THE_END: {
                return false;
            }
            case OVERWORLD: {
                return true;
            }
        }
        return false;
    }

    void generateStructure(Random random, int chunkX, int chunkZ, World world, StructureInfo info) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_189649_b(x, z);
        BlockPos basePos = new BlockPos(x, y, z);
        String structureName = "bassebombecraft:" + info.getName();
        TemplateUtils.load(world, structureName, basePos);
    }
}

