/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft;

import bassebombecraft.config.ModConfiguration;
import bassebombecraft.config.VersionUtils;
import bassebombecraft.entity.commander.DefaultMobCommanderRepository;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.block.DefaultBlockDirectiveRepository;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlockRepository;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.charm.DefaultCharmedMobsRepository;
import bassebombecraft.event.duration.DefaultDurationRepository;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.event.entity.target.DefaultTargetedEntitiesRepository;
import bassebombecraft.event.entity.target.TargetedEntitiesRepository;
import bassebombecraft.event.entity.team.DefaultTeamRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.event.frequency.DefaultFrequencyRepository;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.item.ItemRegistryEventHandler;
import bassebombecraft.event.particle.DefaultParticleRenderingRepository;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.proxy.ClientProxy;
import bassebombecraft.proxy.Proxy;
import bassebombecraft.proxy.ServerProxy;
import bassebombecraft.tab.ItemGroupFactory;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.Random;
import javax.naming.OperationNotSupportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bassebombecraft")
public class BassebombeCraft {
    static Logger logger = LogManager.getLogger();
    static BassebombeCraft instance;
    static Proxy proxy;
    static final ItemGroup MOD_ITEMGROUP;
    CharmedMobsRepository charmedMobsRepository;
    BlockDirectivesRepository blockDirectivesRepository;
    ParticleRenderingRepository particleRepository;
    TemporaryBlockRepository tempBlockRepository;
    MobCommanderRepository mobCommanderRepository;
    TeamRepository teamRepository;
    TargetedEntitiesRepository targetedEntitiesRepository;
    FrequencyRepository frequencyRepository;
    DurationRepository durationRepository;
    MinecraftServer server;
    static Random random;

    public BassebombeCraft() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            ModConfiguration.loadConfig();
            this.frequencyRepository = DefaultFrequencyRepository.getInstance();
            this.durationRepository = DefaultDurationRepository.getInstance();
            this.charmedMobsRepository = DefaultCharmedMobsRepository.getInstance();
            this.blockDirectivesRepository = DefaultBlockDirectiveRepository.getInstance();
            this.tempBlockRepository = DefaultTemporaryBlockRepository.getInstance();
            this.particleRepository = DefaultParticleRenderingRepository.getInstance();
            this.mobCommanderRepository = DefaultMobCommanderRepository.getInstance();
            this.teamRepository = DefaultTeamRepository.getInstance();
            this.targetedEntitiesRepository = DefaultTargetedEntitiesRepository.getInstance();
        }
        catch (ExceptionInInitializerError e) {
            this.reportAndLogException(e);
            throw e;
        }
        catch (Exception e) {
            this.reportAndLogException(e);
            throw e;
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    @SubscribeEvent
    void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    void serverAboutTostart(FMLServerAboutToStartEvent event) {
        this.server = event.getServer();
    }

    @SubscribeEvent
    void serverStarted(FMLServerStartedEvent event) {
        proxy.startAnalyticsSession();
    }

    @SubscribeEvent
    void serverStopped(FMLServerStoppedEvent event) {
        proxy.endAnalyticsSession();
        this.server = null;
    }

    @SubscribeEvent
    void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        VersionUtils.validateVersion(player);
    }

    void initializeWorldGenerators() {
    }

    public static Proxy getProxy() {
        return proxy;
    }

    public CharmedMobsRepository getCharmedMobsRepository() {
        return this.charmedMobsRepository;
    }

    public BlockDirectivesRepository getBlockDirectivesRepository() {
        return this.blockDirectivesRepository;
    }

    public TemporaryBlockRepository getTemporaryBlockRepository() {
        return this.tempBlockRepository;
    }

    public ParticleRenderingRepository getParticleRenderingRepository() {
        return this.particleRepository;
    }

    public MobCommanderRepository getMobCommanderRepository() {
        return this.mobCommanderRepository;
    }

    public TeamRepository getTeamRepository() {
        return this.teamRepository;
    }

    public TargetedEntitiesRepository getTargetedEntitiesRepository() {
        return this.targetedEntitiesRepository;
    }

    public FrequencyRepository getFrequencyRepository() {
        return this.frequencyRepository;
    }

    public DurationRepository getDurationRepository() {
        return this.durationRepository;
    }

    public UnmodifiableConfig getTomlConfiguration() {
        return ModConfiguration.COMMON_CONFIG.getValues();
    }

    public Item[] getInventoryItems() {
        return ItemRegistryEventHandler.getInventoryItems();
    }

    public static BassebombeCraft getBassebombeCraft() {
        return instance;
    }

    public static ItemGroup getItemGroup() {
        return MOD_ITEMGROUP;
    }

    public Logger getLogger() {
        return logger;
    }

    public String getUser() {
        try {
            return proxy.getUser();
        }
        catch (OperationNotSupportedException e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            throw new RuntimeException(e);
        }
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public Random getRandom() {
        return random;
    }

    public static Minecraft getMincraft() {
        return Minecraft.func_71410_x();
    }

    public void reportAndLogException(Throwable e) {
        Optional<String> nullableString = Optional.ofNullable(e.getMessage());
        nullableString.ifPresent(s -> logger.error(s));
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stacktraceString = sw.toString();
        logger.error(stacktraceString);
        this.reportException(e);
    }

    public void reportException(Throwable e) {
        proxy.postException(e);
    }

    static {
        proxy = (Proxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        MOD_ITEMGROUP = ItemGroupFactory.createItemGroup("bassebombecraft");
        random = new Random();
    }
}

