/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ParticlesConfig;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.Optional;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigUtils {
    public static ParticleRenderingInfo[] createFromConfig(ParticlesConfig config) {
        String particleTypeName = (String)config.type.get();
        ResourceLocation key2 = new ResourceLocation(particleTypeName.toLowerCase());
        Optional particleType = Registry.field_212632_u.func_218349_b(key2);
        BasicParticleType castParticleType = (BasicParticleType)particleType.get();
        int number = (Integer)config.number.get();
        int duration = (Integer)config.duration.get();
        double colorR = (Double)config.r.get();
        double colorG = (Double)config.g.get();
        double colorB = (Double)config.b.get();
        double speed = (Double)config.speed.get();
        ParticleRenderingInfo mist = DefaultParticleRenderingInfo.getInstance(castParticleType, number, duration, (float)colorR, (float)colorG, (float)colorB, speed);
        return new ParticleRenderingInfo[]{mist};
    }

    public static int resolveCoolDown(String key, int defaultValue) {
        String tomlPath = key + ".cooldown";
        UnmodifiableConfig config = BassebombeCraft.getBassebombeCraft().getTomlConfiguration();
        if (config.contains(tomlPath)) {
            return ConfigUtils.getInt(tomlPath);
        }
        return defaultValue;
    }

    public static String resolveTooltip(String key, String defaultValue) {
        String tomlPath = key + ".tooltip";
        UnmodifiableConfig config = BassebombeCraft.getBassebombeCraft().getTomlConfiguration();
        if (config.contains(tomlPath)) {
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)config.get(tomlPath);
            return (String)configValue.get();
        }
        return defaultValue;
    }

    public static int getInt(String path) {
        UnmodifiableConfig config = BassebombeCraft.getBassebombeCraft().getTomlConfiguration();
        try {
            ForgeConfigSpec.IntValue configValue = (ForgeConfigSpec.IntValue)config.get(path);
            Integer retval = (Integer)configValue.get();
            return retval;
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            throw e;
        }
    }
}

