/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.config.ParticlesConfig;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class InventoryItemConfig {
    public ForgeConfigSpec.ConfigValue<String> tooltip;
    public ForgeConfigSpec.IntValue cooldown;
    public ForgeConfigSpec.IntValue range;
    public ParticlesConfig particles;

    public InventoryItemConfig(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, int range, Supplier<ParticlesConfig> supplier) {
        builder.comment(name + " settings").push(name);
        this.tooltip = builder.comment("Tooltip for item.").define("tooltip", (Object)tooltip);
        this.cooldown = builder.comment("Game ticks between item activation.").defineInRange("cooldown", cooldown, 0, Integer.MAX_VALUE);
        this.range = builder.comment("Item activation range in blocks. 1 = Not an AOE effect. ").defineInRange("range", range, 0, Integer.MAX_VALUE);
        this.particles = supplier.get();
        builder.pop();
    }

    public static InventoryItemConfig getInstance(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, int range, Supplier<ParticlesConfig> supplier) {
        return new InventoryItemConfig(builder, name, tooltip, cooldown, range, supplier);
    }

    public static InventoryItemConfig getInstanceWithNoRange(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, Supplier<ParticlesConfig> supplier) {
        return new InventoryItemConfig(builder, name, tooltip, cooldown, 1, supplier);
    }
}

