/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.player.PlayerDirection;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityUtils {
    static final float PITCH = 0.0f;

    public static void setProjectileEntityPosition(LivingEntity entity, LivingEntity projectileEntity, int spawnDisplacement) {
        Vec3d lookVec = entity.func_70040_Z();
        double x = entity.field_70165_t + lookVec.field_72450_a * (double)spawnDisplacement;
        double y = entity.field_70163_u + (double)entity.func_70047_e();
        double z = entity.field_70161_v + lookVec.field_72449_c * (double)spawnDisplacement;
        projectileEntity.field_70165_t = x;
        projectileEntity.field_70163_u = y;
        projectileEntity.field_70161_v = z;
        projectileEntity.field_70177_z = projectileEntity.field_70759_as = entity.field_70177_z;
        projectileEntity.field_70126_B = projectileEntity.field_70759_as;
        projectileEntity.field_70127_C = projectileEntity.field_70125_A = entity.field_70125_A;
    }

    public static void explode(LivingEntity entity, World world, int size) {
        world.func_217385_a((Entity)entity, (double)entity.func_180425_c().func_177958_n(), (double)entity.func_180425_c().func_177956_o(), (double)entity.func_180425_c().func_177952_p(), (float)size, Explosion.Mode.DESTROY);
    }

    public static void killEntity(LivingEntity entity) {
        entity.func_174812_G();
    }

    public static boolean isTypeCreatureEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof CreatureEntity;
        }
        return false;
    }

    public static boolean isTypeMobEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof MobEntity;
        }
        return false;
    }

    public static boolean isTypeLivingEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean isTypeCreeperEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof CreeperEntity;
        }
        return false;
    }

    public static boolean isTypeParrotEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof ParrotEntity;
        }
        return false;
    }

    public static boolean isTypeBatEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof BatEntity;
        }
        return false;
    }

    public static double calculateEntityFeetPositition(LivingEntity entity) {
        double feetPosY = entity.field_70163_u - entity.func_70033_W();
        return feetPosY;
    }

    public static int calculateEntityFeetPosititionAsInt(LivingEntity entity) {
        return (int)EntityUtils.calculateEntityFeetPositition(entity);
    }

    public static PlayerDirection getPlayerDirection(LivingEntity entity) {
        int direction = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return PlayerDirection.getById(direction);
    }

    public static boolean hasAliveTarget(LivingEntity entity) {
        Optional<LivingEntity> target = EntityUtils.getNullableTarget(entity);
        if (target.isPresent()) {
            return target.get().func_70089_S();
        }
        return false;
    }

    public static boolean hasTarget(LivingEntity entity) {
        Optional<LivingEntity> target = EntityUtils.getNullableTarget(entity);
        return target.isPresent();
    }

    public static Optional<LivingEntity> getNullableTarget(LivingEntity entity) {
        if (EntityUtils.isTypeCreatureEntity((Entity)entity)) {
            CreatureEntity creatureEntity = (CreatureEntity)entity;
            return Optional.ofNullable(creatureEntity.func_70638_az());
        }
        return Optional.ofNullable(entity.func_110144_aD());
    }

    public static LivingEntity getTarget(LivingEntity entity) {
        if (EntityUtils.isTypeCreatureEntity((Entity)entity)) {
            CreatureEntity typedEntity = (CreatureEntity)entity;
            return typedEntity.func_70638_az();
        }
        return entity.func_110144_aD();
    }

    public static boolean supportTargeting(Entity entity) {
        if (EntityUtils.isTypeCreatureEntity(entity)) {
            return true;
        }
        return EntityUtils.isTypeLivingEntity(entity);
    }

    public static void setTarget(Entity entity, LivingEntity newTarget) {
        if (EntityUtils.isTypeCreatureEntity(entity)) {
            CreatureEntity creatureEntity = (CreatureEntity)entity;
            creatureEntity.func_70624_b(newTarget);
            return;
        }
        if (EntityUtils.isTypeLivingEntity(entity)) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_130011_c((Entity)newTarget);
            livingEntity.func_70604_c(newTarget);
        }
    }

    public static void setMobEntityAggroed(Entity entity) {
        if (EntityUtils.isTypeMobEntity(entity)) {
            MobEntity mobEntity = (MobEntity)entity;
            mobEntity.func_213395_q(true);
        }
    }

    public static void setRandomSpawnPosition(BlockPos pos, float rotationYaw, int spawnArea, LivingEntity entity) {
        EntityUtils.setRandomSpawnPosition(pos, rotationYaw, spawnArea, (Entity)entity);
    }

    public static void setRandomSpawnPosition(BlockPos pos, float rotationYaw, int spawnArea, Entity entity) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int randomX = random.nextInt(spawnArea) - spawnArea / 2;
        int randomZ = random.nextInt(spawnArea) - spawnArea / 2;
        double positionX = pos.func_177958_n() + randomX;
        double positionY = pos.func_177956_o();
        double positionZ = pos.func_177952_p() + randomZ;
        entity.func_70012_b(positionX, positionY, positionZ, rotationYaw, 0.0f);
    }

    public static float calculateRandomYaw() {
        return BassebombeCraft.getBassebombeCraft().getRandom().nextFloat() * 360.0f;
    }

    public static void selfDestruct(MobEntity entity) {
        entity.func_70015_d(1000);
        entity.func_70606_j(0.0f);
    }

    public static boolean isMinimumDistanceReached(Entity entity, Entity entity2, double minDistanceSqr) {
        double distSqr = entity.func_70068_e(entity2);
        return minDistanceSqr > distSqr;
    }
}

