/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai.goal;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.ai.goal.DefaultFacts;
import bassebombecraft.entity.ai.goal.DefaultObservationRepository;
import bassebombecraft.entity.ai.goal.Observation;
import bassebombecraft.entity.ai.goal.ObservationRepository;
import bassebombecraft.entity.ai.goal.SituationalFacts;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.item.action.GenericShootEggProjectile;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.ShootBaconBazooka;
import bassebombecraft.item.action.ShootCreeperCannon;
import bassebombecraft.item.action.ShootLargeFireball;
import bassebombecraft.item.action.ShootMultipleArrows;
import bassebombecraft.item.action.ShootSmallFireball;
import bassebombecraft.item.action.ShootWitherSkull;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import bassebombecraft.item.action.mist.entity.GenericEntityMist;
import bassebombecraft.item.action.mist.entity.LightningBoltMist;
import bassebombecraft.item.action.mist.entity.ToxicMist;
import bassebombecraft.item.action.mist.entity.VacuumMist;
import bassebombecraft.projectile.action.DigMobHole;
import bassebombecraft.projectile.action.EmitHorizontalForce;
import bassebombecraft.projectile.action.EmitVerticalForce;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.projectile.action.SpawnAnvil;
import bassebombecraft.projectile.action.SpawnCobweb;
import bassebombecraft.projectile.action.SpawnFlamingChicken;
import bassebombecraft.projectile.action.SpawnIceBlock;
import bassebombecraft.projectile.action.SpawnLavaBlock;
import bassebombecraft.projectile.action.SpawnLightningBolt;
import bassebombecraft.projectile.action.SpawnSquid;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;

public class CompanionAttack
extends Goal {
    static final ProjectileAction COWEB_PROJECTILE_ACTION = new SpawnCobweb();
    static final ProjectileAction ICEBLOCK_PROJECTILE_ACTION = new SpawnIceBlock();
    static final ProjectileAction LAVABLOCK_PROJECTILE_ACTION = new SpawnLavaBlock();
    static final ProjectileAction LIGHTNING_PROJECTILE_ACTION = new SpawnLightningBolt();
    static final ProjectileAction EMIT_FORCE_PROJECTILE_ACTION = new EmitHorizontalForce();
    static final ProjectileAction EMIT_VERTICAL_FORCE_PROJECTILE_ACTION = new EmitVerticalForce();
    static final ProjectileAction SPAWN_SQUID_PROJECTILE_ACTION = new SpawnSquid();
    static final ProjectileAction FALLING_ANVIL_PROJECTILE_ACTION = new SpawnAnvil();
    static final ProjectileAction MOB_HOLE_PROJECTILE_ACTION = new DigMobHole();
    static final ProjectileAction FLAMING_CHICKEN_PROJECTILE_ACTION = new SpawnFlamingChicken();
    static Supplier<Integer> splDuration = () -> (Integer)ModConfiguration.vacuumMistDuration.get();
    static Supplier<Integer> splForce = () -> (Integer)ModConfiguration.vacuumMistForce.get();
    static final EntityMistActionStrategy SPAWN_VACUUM_MIST_PROJECTILE_ACTION = new VacuumMist(splDuration, splForce);
    static final EntityMistActionStrategy TOXIC_MIST_STRATEGY = new ToxicMist();
    static final EntityMistActionStrategy LIGHTNING_MIST_STRATEGY = new LightningBoltMist();
    static final String CREEPER_CANNON_CONFIG_KEY = ShootCreeperCannon.class.getSimpleName();
    static final boolean ISNT_PRIMED = false;
    double entityMoveSpeed = 1.0;
    static List<RightClickedItemAction> longRangeActions = CompanionAttack.initializeLongRangeActions();
    static List<RightClickedItemAction> closeRangeActions = CompanionAttack.initializeCloseRangeActions();
    PlayerEntity commander;
    MobEntity entity;
    SituationalFacts targetFacts = DefaultFacts.getInstance();
    ObservationRepository observationRepository;

    public CompanionAttack(MobEntity entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        this.observationRepository = DefaultObservationRepository.getInstance((LivingEntity)entity);
    }

    public CompanionAttack(MobEntity entity, PlayerEntity commander) {
        this(entity);
        this.commander = commander;
    }

    public boolean func_75250_a() {
        if (!EntityUtils.hasTarget((LivingEntity)this.entity)) {
            return false;
        }
        Optional<LivingEntity> optTarget = EntityUtils.getNullableTarget((LivingEntity)this.entity);
        if (!optTarget.isPresent()) {
            return false;
        }
        this.observeAndupdateFacts(optTarget.get());
        return optTarget.get().func_70089_S();
    }

    public void func_75246_d() {
        try {
            FrequencyRepository repository = BassebombeCraft.getBassebombeCraft().getFrequencyRepository();
            if (!repository.isActive(10)) {
                return;
            }
            Optional<LivingEntity> optTarget = Optional.ofNullable(EntityUtils.getTarget((LivingEntity)this.entity));
            if (!optTarget.isPresent()) {
                return;
            }
            this.lookAtTarget(optTarget.get());
            PathNavigator navigator = this.entity.func_70661_as();
            if (this.targetFacts.isTargetClose()) {
                navigator.func_75499_g();
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)optTarget.get(), this.entityMoveSpeed);
            }
            if (this.targetFacts.isTargetClose()) {
                this.selectAction(closeRangeActions);
            } else {
                this.selectAction(longRangeActions);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void func_75251_c() {
        this.observationRepository.clear();
    }

    void observeAndupdateFacts(LivingEntity target) {
        Observation observation = this.observationRepository.observe(target);
        if (this.observationRepository.isTooFewObservationsRegistered()) {
            return;
        }
        Stream<Observation> observations = this.observationRepository.get();
        this.targetFacts.update(observations);
    }

    static List<RightClickedItemAction> initializeLongRangeActions() {
        ArrayList<RightClickedItemAction> actions = new ArrayList<RightClickedItemAction>();
        actions.add(new ShootSmallFireball());
        actions.add(new ShootLargeFireball());
        actions.add(new ShootWitherSkull());
        actions.add(new ShootMultipleArrows());
        actions.add(new ShootBaconBazooka());
        actions.add(new ShootCreeperCannon(false));
        actions.add(new GenericShootEggProjectile(SPAWN_SQUID_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(FALLING_ANVIL_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(LIGHTNING_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(MOB_HOLE_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(FLAMING_CHICKEN_PROJECTILE_ACTION));
        return actions;
    }

    static List<RightClickedItemAction> initializeCloseRangeActions() {
        ArrayList<RightClickedItemAction> actions = new ArrayList<RightClickedItemAction>();
        actions.add(new GenericEntityMist(TOXIC_MIST_STRATEGY));
        actions.add(new GenericShootEggProjectile(COWEB_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(EMIT_FORCE_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(EMIT_VERTICAL_FORCE_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(ICEBLOCK_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(LAVABLOCK_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(SPAWN_SQUID_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(FALLING_ANVIL_PROJECTILE_ACTION));
        actions.add(new GenericEntityMist(SPAWN_VACUUM_MIST_PROJECTILE_ACTION));
        actions.add(new GenericShootEggProjectile(LIGHTNING_PROJECTILE_ACTION));
        actions.add(new GenericEntityMist(LIGHTNING_MIST_STRATEGY));
        actions.add(new GenericShootEggProjectile(MOB_HOLE_PROJECTILE_ACTION));
        return actions;
    }

    void lookAtTarget(LivingEntity target) {
        LookController lookController = this.entity.func_70671_ap();
        lookController.func_75651_a((Entity)target, 10.0f, (float)this.entity.func_70646_bf());
    }

    String selectAction(List<RightClickedItemAction> actions) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int numberActions = actions.size();
        int choice = random.nextInt(numberActions);
        RightClickedItemAction action = actions.get(choice);
        action.onRightClick(this.entity.func_130014_f_(), (LivingEntity)this.entity);
        return action.getClass().getSimpleName();
    }
}

