/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.commander;

import bassebombecraft.entity.commander.MobCommand;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.entity.commander.command.AttackCommandersTargetCommand;
import bassebombecraft.entity.commander.command.AttackNearestMobCommand;
import bassebombecraft.entity.commander.command.AttackNearestPlayerCommand;
import bassebombecraft.entity.commander.command.DanceCommand;
import bassebombecraft.entity.commander.command.NullCommand;
import bassebombecraft.player.PlayerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class DefaultMobCommanderRepository
implements MobCommanderRepository {
    static final AttackNearestMobCommand ATTACK_NEAREST_MOB_COMMAND = new AttackNearestMobCommand();
    static final AttackNearestPlayerCommand ATTACK_NEAREST_PLAYER_COMMAND = new AttackNearestPlayerCommand();
    static final DanceCommand STOP_COMMAND = new DanceCommand();
    static final AttackCommandersTargetCommand ATTACK_COMMANDERS_TARGET_COMMAND = new AttackCommandersTargetCommand();
    public static final MobCommand NULL_COMMAND = new NullCommand();
    Map<LivingEntity, MobCommanderState> commanders = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean isRegistered(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        return this.commanders.containsKey(entity);
    }

    @Override
    public void register(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.isRegistered(entity)) {
            return;
        }
        MobCommanderState state = new MobCommanderState(NULL_COMMAND);
        this.commanders.put(entity, state);
    }

    @Override
    public void remove(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        this.commanders.remove(entity);
    }

    @Override
    public void clear() {
        this.commanders.clear();
    }

    @Override
    public MobCommand getCommand(LivingEntity entity) {
        if (entity == null) {
            return NULL_COMMAND;
        }
        if (!this.isRegistered(entity)) {
            return NULL_COMMAND;
        }
        MobCommanderState state = this.commanders.get(entity);
        return state.getCommand();
    }

    @Override
    public void cycle(LivingEntity entity) {
        this.register(entity);
        MobCommanderState state = this.commanders.get(entity);
        MobCommand command = state.getCommand();
        this.internalCycleCommand(state, command);
        command = state.getCommand();
        if (PlayerUtils.isTypePlayerEntity((Entity)entity)) {
            PlayerEntity player = (PlayerEntity)entity;
            PlayerUtils.sendChatMessageToPlayer(player, "Krenko commands: " + command.getTitle());
        }
    }

    void internalCycleCommand(MobCommanderState state, MobCommand command) {
        switch (command.getType()) {
            case NULL: {
                state.setCommand(STOP_COMMAND);
                return;
            }
            case STOP: {
                state.setCommand(ATTACK_COMMANDERS_TARGET_COMMAND);
                return;
            }
            case COMMANDERS_TARGET: {
                state.setCommand(ATTACK_NEAREST_MOB_COMMAND);
                return;
            }
            case NEAREST_MOB: {
                state.setCommand(ATTACK_NEAREST_PLAYER_COMMAND);
                return;
            }
            case NEAREST_PLAYER: {
                state.setCommand(NULL_COMMAND);
                return;
            }
        }
        state.setCommand(NULL_COMMAND);
    }

    public static MobCommanderRepository getInstance() {
        return new DefaultMobCommanderRepository();
    }

    class MobCommanderState {
        MobCommand command;

        public MobCommanderState(MobCommand command) {
            this.command = command;
        }

        public MobCommand getCommand() {
            return this.command;
        }

        public void setCommand(MobCommand command) {
            this.command = command;
        }
    }
}

