/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.Logger;

public class DefaultBlockDirectiveRepository
implements BlockDirectivesRepository {
    BlockingQueue<BlockDirective> queue = new LinkedBlockingQueue<BlockDirective>();

    @Override
    public void add(BlockDirective directive) {
        if (directive == null) {
            return;
        }
        try {
            this.queue.put(directive);
        }
        catch (InterruptedException e) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Failed to add block directive: " + directive + " due to exception: " + e);
            BassebombeCraft.getBassebombeCraft().reportException(e);
        }
    }

    @Override
    public void addAll(List<BlockDirective> directives) {
        if (directives.isEmpty()) {
            return;
        }
        this.queue.addAll(directives);
    }

    @Override
    public boolean containsDirectives() {
        return !this.queue.isEmpty();
    }

    @Override
    public BlockDirective getNext() throws Exception {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.take();
    }

    public static BlockDirectivesRepository getInstance() {
        return new DefaultBlockDirectiveRepository();
    }
}

