/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQueryImpl;
import bassebombecraft.world.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProcessBlockDirectivesEventHandler {
    static final float R = 1.0f;
    static final float G = 1.0f;
    static final float B = 1.0f;
    static final int PARTICLE_NUMBER = 5;
    static final BasicParticleType PARTICLE_TYPE = ParticleTypes.field_197620_m;
    static final int PARTICLE_DURATION = 20;
    static final double PARTICLE_SPEED = 3.0;
    static final ParticleRenderingInfo PARTICLE_INFO = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 5, 20, 1.0f, 1.0f, 1.0f, 3.0);
    static final BlockPos NULL_POSITION = null;

    @SubscribeEvent
    public static void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) throws Exception {
        BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        if (!repository.containsDirectives()) {
            return;
        }
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        if (WorldUtils.isWorldAtClientSide(world)) {
            return;
        }
        WorldQueryImpl worldQuery = new WorldQueryImpl(player, NULL_POSITION);
        for (int i = 0; i < 3; ++i) {
            ProcessBlockDirectivesEventHandler.processDirective(world, worldQuery);
        }
    }

    static void processDirective(World world, WorldQueryImpl worldQuery) throws Exception {
        BlockDirectivesRepository directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        ParticleRenderingRepository particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        while (directivesRepository.containsDirectives()) {
            BlockDirective directive = directivesRepository.getNext();
            BlockState currentState = world.func_180495_p(directive.getBlockPosition());
            if (currentState.equals((Object)directive.getState())) continue;
            BlockUtils.createBlock(directive, worldQuery);
            BlockPos pos = directive.getBlockPosition();
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, PARTICLE_INFO);
            particleRepository.add(particle);
        }
    }
}

