/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.block.temporary;

import bassebombecraft.event.block.temporary.TemporaryBlock;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.geom.BlockDirective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultTemporaryBlockRepository
implements TemporaryBlockRepository {
    static final List<BlockDirective> EMPTY_LIST = new ArrayList<BlockDirective>();
    Set<TemporaryBlock> tempBlocks = Collections.synchronizedSet(new HashSet());
    List<BlockDirective> directives = new ArrayList<BlockDirective>();

    @Override
    public void add(TemporaryBlock block) {
        if (this.tempBlocks.contains(block)) {
            return;
        }
        this.tempBlocks.add(block);
        this.directives.add(block.getTemporaryBlock());
    }

    @Override
    public void remove(TemporaryBlock block) {
        this.tempBlocks.remove(block);
    }

    @Override
    public List<BlockDirective> getBlockDirectives() {
        if (this.directives.isEmpty()) {
            return EMPTY_LIST;
        }
        ArrayList<BlockDirective> list = new ArrayList<BlockDirective>(this.directives);
        this.directives.clear();
        return list;
    }

    @Override
    public void clear() {
        this.tempBlocks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlockDuration() {
        Set<TemporaryBlock> set = this.tempBlocks;
        synchronized (set) {
            Iterator<TemporaryBlock> it = this.tempBlocks.iterator();
            while (it.hasNext()) {
                TemporaryBlock particle = it.next();
                particle.updateDuration();
                if (!particle.isExpired()) continue;
                it.remove();
                this.directives.add(particle.getFinalBlock());
            }
        }
    }

    public static TemporaryBlockRepository getInstance() {
        return new DefaultTemporaryBlockRepository();
    }
}

