/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.duration.DurationRepository;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.PrioritizedGoal;

public class CharmedMob {
    String id;
    final Set<PrioritizedGoal> goals;
    final Set<PrioritizedGoal> targetGoals;
    final MobEntity entity;

    CharmedMob(MobEntity entity, int duration) {
        this.entity = entity;
        this.goals = AiUtils.captureGoals(entity.field_70714_bg);
        this.targetGoals = AiUtils.captureGoals(entity.field_70715_bh);
        DurationRepository repository = BassebombeCraft.getBassebombeCraft().getDurationRepository();
        this.id = entity.func_200200_C_().func_150261_e();
        repository.add(this.id, duration);
    }

    public Set<PrioritizedGoal> getGoals() {
        return this.goals;
    }

    public Set<PrioritizedGoal> getTargetGoals() {
        return this.targetGoals;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public boolean isCharmExpired() {
        DurationRepository repository = BassebombeCraft.getBassebombeCraft().getDurationRepository();
        return repository.isExpired(this.id);
    }

    public int getDuration() {
        DurationRepository repository = BassebombeCraft.getBassebombeCraft().getDurationRepository();
        if (repository.isExpired(this.id)) {
            return 0;
        }
        return repository.get(this.id);
    }

    public static CharmedMob getInstance(MobEntity entity, int duration) {
        return new CharmedMob(entity, duration);
    }
}

