/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CharmedMobEventHandler {
    static final float R = 1.0f;
    static final float G = 1.0f;
    static final float B = 1.0f;
    static final int PARTICLE_NUMBER = 1;
    static final BasicParticleType PARTICLE_TYPE = ParticleTypes.field_197633_z;
    static final int PARTICLE_DURATION = 20;
    static final double PARTICLE_SPEED = 0.3;
    static final ParticleRenderingInfo PARTICLE_INFO = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 1, 20, 1.0f, 1.0f, 1.0f, 0.3);

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!EntityUtils.isTypeMobEntity((Entity)event.getEntityLiving())) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntityLiving();
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        FrequencyRepository frequencyRepository = BassebombeCraft.getBassebombeCraft().getFrequencyRepository();
        if (!repository.contains(entity)) {
            return;
        }
        repository.update(entity);
        if (!frequencyRepository.isActive(20)) {
            return;
        }
        ParticleRenderingRepository particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        BlockPos pos = entity.func_180425_c();
        ParticleRendering particle = DefaultParticleRendering.getInstance(pos, PARTICLE_INFO);
        particleRepository.add(particle);
    }

    @SubscribeEvent
    public static void handleEvent(LivingDeathEvent event) {
        if (!EntityUtils.isTypeMobEntity((Entity)event.getEntityLiving())) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntityLiving();
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        repository.remove(entity);
    }
}

