/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;

public class DefaultCharmedMobsRepository
implements CharmedMobsRepository {
    static final int EFFECT_DURATION = 1000;
    Map<MobEntity, CharmedMob> charmedMobs = new ConcurrentHashMap<MobEntity, CharmedMob>();

    @Override
    public void add(MobEntity entity, LivingEntity commander) {
        TeamRepository teamRepository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
        if (teamRepository.isMember(commander, (LivingEntity)entity)) {
            return;
        }
        CharmedMob charmedMob = CharmedMob.getInstance(entity, 1000);
        AiUtils.clearAllAiGoals(entity);
        AiUtils.buildCharmedMobAi(entity, commander);
        this.charmedMobs.put(entity, charmedMob);
    }

    @Override
    public void remove(MobEntity entity) {
        if (!this.contains(entity)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(entity);
        AiUtils.clearAllAiGoals(entity);
        AiUtils.assignAiGoals(entity, charmedMob.getGoals());
        AiUtils.assignAiTargetGoals(entity, charmedMob.getTargetGoals());
        this.charmedMobs.remove(entity);
    }

    @Override
    public void update(MobEntity entity) {
        if (!this.contains(entity)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(entity);
        if (charmedMob.isCharmExpired()) {
            this.remove(entity);
        }
    }

    @Override
    public boolean contains(MobEntity entity) {
        return this.charmedMobs.containsKey(entity);
    }

    @Override
    public Collection<CharmedMob> get() {
        return this.charmedMobs.values();
    }

    public static CharmedMobsRepository getInstance() {
        return new DefaultCharmedMobsRepository();
    }
}

