/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.duration;

import bassebombecraft.event.duration.DefaultDuration;
import bassebombecraft.event.duration.Duration;
import bassebombecraft.event.duration.DurationRepository;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDurationRepository
implements DurationRepository {
    ConcurrentHashMap<String, Duration> durableObjects = new ConcurrentHashMap();

    @Override
    public void update() {
        ArrayList expired = new ArrayList();
        this.durableObjects.forEachKey(10L, k -> {
            Duration state = this.durableObjects.get(k);
            state.update();
            if (this.isExpired((String)k)) {
                expired.add(k);
            }
        });
        expired.forEach(k -> this.durableObjects.remove(k));
    }

    @Override
    public void add(String id, int duration) {
        if (this.durableObjects.containsKey(id)) {
            return;
        }
        Duration state = DefaultDuration.getInstance(duration, id);
        this.durableObjects.put(id, state);
    }

    @Override
    public boolean isExpired(String id) {
        if (!this.durableObjects.containsKey(id)) {
            return true;
        }
        Duration state = this.durableObjects.get(id);
        return state.isExpired();
    }

    @Override
    public int get(String id) {
        if (!this.durableObjects.containsKey(id)) {
            return 0;
        }
        Duration state = this.durableObjects.get(id);
        return state.get();
    }

    public static DurationRepository getInstance() {
        return new DefaultDurationRepository();
    }
}

