/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.target;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.entity.target.TargetedEntitiesRepository;
import bassebombecraft.player.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TargetedEntitiesEventHandler {
    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        TargetedEntitiesRepository repository = BassebombeCraft.getBassebombeCraft().getTargetedEntitiesRepository();
        LivingEntity entity = event.getEntityLiving();
        repository.remove(entity);
        if (PlayerUtils.isTypePlayerEntity((Entity)event.getEntityLiving())) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (!repository.isCommander(player)) {
                return;
            }
            repository.clear(player);
        }
    }

    @SubscribeEvent
    public static void handleAttackEntityEvent(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        if (!EntityUtils.isTypeLivingEntity(target)) {
            return;
        }
        LivingEntity targetAsLivingEntity = (LivingEntity)target;
        TargetedEntitiesRepository repository = BassebombeCraft.getBassebombeCraft().getTargetedEntitiesRepository();
        repository.add(player, targetAsLivingEntity);
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        TargetedEntitiesRepository repository = BassebombeCraft.getBassebombeCraft().getTargetedEntitiesRepository();
        repository.createTargets(event.getPlayer());
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        TargetedEntitiesRepository repository = BassebombeCraft.getBassebombeCraft().getTargetedEntitiesRepository();
        repository.deleteTargets(event.getPlayer());
    }
}

