/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.team;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.player.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TeamMembershipEventHandler {
    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        TeamRepository repository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
        if (EntityUtils.isTypeLivingEntity((Entity)event.getEntityLiving())) {
            LivingEntity entity = event.getEntityLiving();
            repository.remove(entity);
            return;
        }
        if (PlayerUtils.isTypePlayerEntity((Entity)event.getEntityLiving())) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (!repository.isCommander(player)) {
                return;
            }
            repository.deleteTeam(player);
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        TeamRepository repository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
        repository.createTeam(event.getPlayer());
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        TeamRepository repository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
        repository.deleteTeam(event.getPlayer());
    }
}

