/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import java.util.Random;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;

public class DefaultParticleRendering
implements ParticleRendering {
    static final int INFINITE_DURATION = -1;
    private BlockPos position;
    private int duration;
    private ParticleRenderingInfo info;

    private DefaultParticleRendering(BlockPos pos, ParticleRenderingInfo info) {
        this.position = pos;
        this.info = info;
        this.duration = info.getDuration();
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public BasicParticleType getParticleType() {
        return this.info.getParticleType();
    }

    @Override
    public int getNumber() {
        return this.info.getNumber();
    }

    @Override
    public void updateDuration() {
        if (this.duration > 0) {
            --this.duration;
        }
    }

    @Override
    public boolean isExpired() {
        return this.duration == 0;
    }

    @Override
    public float getRedColorComponent(Random random) {
        float rgbRed = this.info.getRedColorComponent();
        return random.nextFloat() * 0.25f + rgbRed * 0.75f - 0.12f;
    }

    @Override
    public float getGreenColorComponent(Random random) {
        float rgbGreen = this.info.getGreenColorComponent();
        return random.nextFloat() * 0.25f + rgbGreen * 0.75f - 0.12f;
    }

    @Override
    public float getBlueColorComponent(Random random) {
        float rgbBlue = this.info.getBlueColorComponent();
        return random.nextFloat() * 0.25f + rgbBlue * 0.75f - 0.12f;
    }

    @Override
    public double getSpeed() {
        return this.info.getSpeed();
    }

    public static ParticleRendering getInstance(BlockPos pos, ParticleRenderingInfo info) {
        return new DefaultParticleRendering(pos, info);
    }
}

