/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.world.WorldUtils;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ParticleRenderingEventHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        ParticleRenderingRepository repository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        FrequencyRepository frequencyRepository = BassebombeCraft.getBassebombeCraft().getFrequencyRepository();
        repository.updateParticleDuration();
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        if (world == null) {
            return;
        }
        if (WorldUtils.isWorldAtServerSide(world)) {
            return;
        }
        if (!frequencyRepository.isActive(3)) {
            return;
        }
        ParticleRenderingEventHandler.render(world, repository);
    }

    static void render(World world, ParticleRenderingRepository repository) {
        try {
            ParticleRendering[] particles;
            for (ParticleRendering particle : particles = repository.getParticles()) {
                int numberToRender = particle.getNumber();
                for (int i = 0; i < numberToRender; ++i) {
                    if (ParticleRenderingEventHandler.renderWithCustomColor(particle)) {
                        ParticleRenderingEventHandler.renderParticleWithCustomColor(world, particle);
                        continue;
                    }
                    ParticleRenderingEventHandler.renderParticle(world, particle);
                }
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static boolean renderWithCustomColor(ParticleRendering particle) {
        BasicParticleType type = particle.getParticleType();
        return type == ParticleTypes.field_197620_m;
    }

    static void renderParticle(World world, ParticleRendering particle) {
        double speed = particle.getSpeed();
        double d0 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double d1 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double d2 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = particle.getPosition().func_177956_o() + 1;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        world.func_195594_a((IParticleData)particle.getParticleType(), x, y, z, d0, d1, d2);
    }

    static void renderParticleWithCustomColor(World world, ParticleRendering particle) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        double speed = particle.getSpeed();
        double d0 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double d1 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double d2 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        float r = particle.getRedColorComponent(random);
        float g = particle.getGreenColorComponent(random);
        float b = particle.getBlueColorComponent(random);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = particle.getPosition().func_177956_o() + 1;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        ParticleManager manager = BassebombeCraft.getMincraft().field_71452_i;
        Particle spellParticle = manager.func_199280_a((IParticleData)ParticleTypes.field_197620_m, x, y, z, d0, d1, d2);
        spellParticle.func_70538_b(r, g, b);
    }

    static double calculateRandomSpeed(double speed) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        return (random.nextDouble() * 2.0 - 1.0) * speed;
    }
}

