/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.potion;

import bassebombecraft.ModConstants;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.potion.PotionUtils;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MobRespawningEffectEventHandler {
    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        if (!PlayerUtils.isPlayerDefined()) {
            return;
        }
        PlayerEntity player = PlayerUtils.getPlayer();
        Optional<EffectInstance> optEffect = PotionUtils.getEffectIfActive((LivingEntity)player, ModConstants.MOB_RESPAWNING_EFFECT);
        if (!optEffect.isPresent()) {
            return;
        }
        int amplifier = optEffect.get().func_76458_c();
        Optional<LivingEntity> optLivingEntity = Optional.ofNullable(event.getEntityLiving());
        if (!optLivingEntity.isPresent()) {
            return;
        }
        Entity deadEntity = (Entity)optLivingEntity.get();
        float distance = player.func_70032_d(deadEntity);
        if (distance > (float)((Integer)ModConfiguration.mobRespawningEffectAreaOfEffect.get()).intValue()) {
            return;
        }
        int entities = MobRespawningEffectEventHandler.calculateEntities(player, amplifier);
        IntStream.rangeClosed(1, entities).forEach(n -> MobRespawningEffectEventHandler.spawnEntity(deadEntity));
    }

    static int calculateEntities(PlayerEntity player, int amplifier) {
        if (!PotionUtils.isAmplifierEffectActive((LivingEntity)player)) {
            return Math.max(1, amplifier);
        }
        int entities = amplifier / 8 + 1;
        return Math.max(1, entities);
    }

    static void spawnEntity(Entity deadEntity) {
        World world = deadEntity.func_130014_f_();
        EntityType type = deadEntity.func_200600_R();
        Entity spawnedEntity = type.func_200721_a(world);
        int spawnArea = (Integer)ModConfiguration.mobRespawningEffectSpawnArea.get();
        EntityUtils.setRandomSpawnPosition(deadEntity.func_180425_c(), EntityUtils.calculateRandomYaw(), spawnArea, spawnedEntity);
        world.func_217376_c(spawnedEntity);
        LivingEntity livingEntity = (LivingEntity)spawnedEntity;
        livingEntity.func_195064_c(MobRespawningEffectEventHandler.createEffect());
    }

    static EffectInstance createEffect() {
        return new EffectInstance(ModConstants.PLAYER_AGGRO_EFFECT, ((Integer)ModConfiguration.mobRespawningEffectDuration.get()).intValue());
    }
}

