/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.DefaultBuildMineRenderer;
import bassebombecraft.rendering.DefaultCharmedInfoRenderer;
import bassebombecraft.rendering.DefaultCharmedRenderer;
import bassebombecraft.rendering.DefaultLookAtBlockRenderer;
import bassebombecraft.rendering.DefaultRenderingInfo;
import bassebombecraft.rendering.DefaultTargetsInfoRenderer;
import bassebombecraft.rendering.DefaultTeamInfoRenderer;
import bassebombecraft.rendering.DefaultTeamRenderer;
import bassebombecraft.rendering.EntityRenderer;
import bassebombecraft.rendering.RenderingInfo;
import bassebombecraft.rendering.RenderingUtils;
import javax.vecmath.Vector4f;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RenderingEventHandler {
    static final int TEXT_RANDOM_Y_OFFSET = 27;
    static final EntityRenderer teamRenderer = new DefaultTeamRenderer();
    static final EntityRenderer teamInfoRenderer = new DefaultTeamInfoRenderer();
    static final EntityRenderer charmedRenderer = new DefaultCharmedRenderer();
    static final EntityRenderer charmedInfoRenderer = new DefaultCharmedInfoRenderer();
    static final EntityRenderer targetsInfoRenderer = new DefaultTargetsInfoRenderer();
    static final EntityRenderer lookedAtBlockRenderer = new DefaultLookAtBlockRenderer();
    static final EntityRenderer buildMineRenderer = new DefaultBuildMineRenderer();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleEntityViewRenderEvent(EntityViewRenderEvent event) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleRenderLivingEvent(RenderLivingEvent event) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleRenderGameOverlayEvent(RenderGameOverlayEvent event) {
        if (!PlayerUtils.isPlayerDefined()) {
            return;
        }
        PlayerEntity player = PlayerUtils.getPlayer();
        if (!PlayerUtils.isItemInHotbar(player, ModConstants.HUD_ITEM)) {
            return;
        }
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, event.getPartialTicks());
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        String text = "Player view info:";
        MainWindow window = event.getWindow();
        int x = (window.func_198107_o() - fontRenderer.func_78256_a(text)) / 2;
        int y = window.func_198087_p() - 27 - 50;
        fontRenderer.func_211126_b(text, (float)x, (float)y, 49152);
        fontRenderer.func_211126_b("Position: " + playerPos, (float)x, (float)(y + 10), 49152);
        fontRenderer.func_211126_b("Look: " + player.func_70040_Z(), (float)x, (float)(y + 20), 49152);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (!PlayerUtils.isPlayerDefined()) {
            return;
        }
        PlayerEntity player = PlayerUtils.getPlayer();
        if (PlayerUtils.isItemInHotbar(player, ModConstants.HUD_ITEM)) {
            RenderingEventHandler.renderHudItem(event, player);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        if (!PlayerUtils.isPlayerDefined()) {
            return;
        }
        PlayerEntity player = PlayerUtils.getPlayer();
        try {
            RenderingInfo info = DefaultRenderingInfo.getInstance(event.getPartialTicks(), event.getTarget());
            if (PlayerUtils.isItemInHotbar(player, ModConstants.HUD_ITEM)) {
                lookedAtBlockRenderer.render((LivingEntity)player, info);
            }
            if (PlayerUtils.isItemHeldInEitherHands(player, ModConstants.BUILD_MINE_BOOK)) {
                buildMineRenderer.render((LivingEntity)player, info);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void renderHudItem(RenderWorldLastEvent event, PlayerEntity player) {
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, event.getPartialTicks());
        try {
            RenderingInfo info = DefaultRenderingInfo.getInstance(event.getPartialTicks());
            teamRenderer.render((LivingEntity)player, info);
            teamInfoRenderer.render((LivingEntity)player, info);
            charmedRenderer.render((LivingEntity)player, info);
            charmedInfoRenderer.render((LivingEntity)player, info);
            targetsInfoRenderer.render((LivingEntity)player, info);
            Vec3d renderPos = RenderingUtils.getRenderPos();
            Vec3d translation = playerPos.func_178788_d(renderPos);
            RenderingEventHandler.renderCompass(translation);
            RenderingEventHandler.renderHudVersionInfo(translation);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void renderHudVersionInfo(Vec3d translation) {
        RenderingUtils.renderTextBillboardV2(translation.func_72441_c(5.0, 5.0, 0.0), "HUD // BasseBombeCraft, version 1.14.4-1.38", ModConstants.TEXT_BILLBOARD_ROTATION);
    }

    static void renderCompass(Vec3d translation) {
        Vec3d ct = translation.func_72441_c(5.0, 0.0, 0.0);
        Vector4f br1 = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br1, "-E-");
        Vector4f br2 = new Vector4f(0.0f, 1.0f, 0.0f, 45.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br2, "-NE-");
        Vector4f br3 = new Vector4f(0.0f, 1.0f, 0.0f, 90.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br3, "-N-");
        Vector4f br4 = new Vector4f(0.0f, 1.0f, 0.0f, 135.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br4, "-NW-");
        Vector4f br5 = new Vector4f(0.0f, 1.0f, 0.0f, 180.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br5, "-W-");
        Vector4f br6 = new Vector4f(0.0f, 1.0f, 0.0f, 225.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br6, "-SW-");
        Vector4f br7 = new Vector4f(0.0f, 1.0f, 0.0f, 270.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br7, "-S-");
        Vector4f br8 = new Vector4f(0.0f, 1.0f, 0.0f, 315.0f);
        RenderingUtils.renderRotatedTextBillboard(ct, br8, "-SE-");
    }
}

