/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.geom;

import bassebombecraft.block.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class BlockDirective {
    Block block;
    boolean harvest;
    BlockPos blockPos;
    BlockState state;

    public BlockDirective() {
        this.set(0, 0, 0);
        this.block = Blocks.field_150350_a;
        this.harvest = true;
    }

    @Deprecated
    public BlockDirective(int x, int y, int z) {
        this.set(x, y, z);
        this.block = Blocks.field_150350_a;
        this.harvest = true;
    }

    public BlockDirective(BlockDirective other) {
        this.set(other.getBlockPosition());
        this.block = other.block;
        this.harvest = other.harvestBlock();
        this.state = other.getState();
    }

    public BlockDirective(BlockPos blockPos, Block block, boolean harvest) {
        this.blockPos = blockPos;
        this.block = block;
        this.harvest = harvest;
    }

    public BlockDirective(BlockPos blockPos, Block block) {
        this(blockPos, block, true);
    }

    public int getX() {
        return this.blockPos.func_177958_n();
    }

    public int getY() {
        return this.blockPos.func_177956_o();
    }

    public int getZ() {
        return this.blockPos.func_177952_p();
    }

    void set(int x, int y, int z) {
        this.blockPos = new BlockPos(x, y, z);
    }

    void set(BlockPos position) {
        this.blockPos = new BlockPos((Vec3i)position);
    }

    public int hashCode() {
        return this.blockPos.func_177958_n() + (this.blockPos.func_177956_o() << 8) + (this.blockPos.func_177952_p() << 16);
    }

    public boolean equals(Object other) {
        if (BlockUtils.isTypeBlockDirective(other)) {
            return this.equals((BlockDirective)other);
        }
        return false;
    }

    public boolean equals(BlockDirective other) {
        return this.blockPos.equals((Object)other.getBlockPosition());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean harvestBlock() {
        if (this.getBlock() != Blocks.field_150350_a) {
            return false;
        }
        return this.harvest;
    }

    public BlockPos getBlockPosition() {
        return this.blockPos;
    }

    public boolean isStateful() {
        return this.state != null;
    }

    public BlockState getState() {
        if (this.isStateful()) {
            return this.state;
        }
        return this.block.func_176223_P();
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public void translate(BlockPos translationVector) {
        int x = this.blockPos.func_177958_n() - translationVector.func_177958_n();
        int y = this.blockPos.func_177956_o() - translationVector.func_177956_o();
        int z = this.blockPos.func_177952_p() - translationVector.func_177952_p();
        this.set(x, y, z);
    }

    public static BlockDirective getInstance(BlockPos blockPos, Block block, BlockState blockState, boolean harvest) {
        BlockDirective directive = new BlockDirective(blockPos.func_185334_h(), block, harvest);
        directive.setState(blockState);
        return directive;
    }
}

