/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildAbyss
implements BlockClickedItemAction {
    private static final int HOLE_WIDTH_AND_DEPTH = 5;
    private static final int WATER_HEIGHT = 2;
    private static final int HOLE_HEIGHT = 50;
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    static final int STATE_UPDATE_FREQUENCY = 1;
    Random random = new Random();
    int ticksExisted = 0;
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        if (this.ticksExisted % 1 != 0) {
            return DIDNT_USED_ITEM;
        }
        Structure structure = this.createStructure();
        PlayerEntity player = context.func_195999_j();
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos pos = context.func_195995_a();
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        this.repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createStructure() {
        CompositeStructure composite = new CompositeStructure();
        int zOffset = -1;
        for (int i = 0; i < 50; ++i) {
            int yOffset = -i;
            this.addLayer(composite, yOffset, zOffset);
        }
        BlockPos offset = new BlockPos(-2, -50, 0);
        BlockPos size = new BlockPos(5, 2, 5);
        composite.add(ChildStructure.createWaterStructure(offset, size));
        return composite;
    }

    void addLayer(Structure composite, int yOffset, int zOffset) {
        BlockPos offset = new BlockPos(-2, yOffset, zOffset + 1);
        BlockPos size = new BlockPos(5, 1, 5);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-1, yOffset, zOffset + 1 + 5);
        size = new BlockPos(3, 1, 1);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-1, yOffset, zOffset);
        size = new BlockPos(3, 1, 1);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(3, yOffset, zOffset + 2);
        size = new BlockPos(1, 1, 3);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-3, yOffset, zOffset + 2);
        size = new BlockPos(1, 1, 3);
        composite.add(ChildStructure.createAirStructure(offset, size));
    }
}

