/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildSmallHole
implements BlockClickedItemAction {
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    static final BlockPos HORIZONTAL_OFFSET = new BlockPos(-1, -1, -1);
    static final BlockPos HORIZONTAL_SIZE = new BlockPos(3, 1, 3);
    static final BlockPos VERTICAL_OFFSET = new BlockPos(-1, 0, 0);
    static final BlockPos VERTICAL_SIZE = new BlockPos(3, 3, 1);
    static final int STATE_UPDATE_FREQUENCY = 1;
    int ticksExisted = 0;

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        if (this.ticksExisted % 1 != 0) {
            return DIDNT_USED_ITEM;
        }
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(pos.func_177956_o(), player);
        Structure structure = null;
        structure = isGroundBlock ? this.createHorizontalStructure() : this.createVerticalStructure();
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createHorizontalStructure() {
        CompositeStructure composite = CompositeStructure.getInstance();
        composite.add(ChildStructure.createAirStructure(HORIZONTAL_OFFSET, HORIZONTAL_SIZE));
        return composite;
    }

    Structure createVerticalStructure() {
        CompositeStructure composite = CompositeStructure.getInstance();
        composite.add(ChildStructure.createAirStructure(VERTICAL_OFFSET, VERTICAL_SIZE));
        return composite;
    }
}

