/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.item.action.build.BuildUtils;
import bassebombecraft.item.action.build.tower.BuildMaterial;
import bassebombecraft.item.action.build.tower.Builder;
import bassebombecraft.item.action.build.tower.DefaultBuilder;
import bassebombecraft.item.action.build.tower.Room;
import bassebombecraft.item.action.build.tower.Wall;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildTower
implements BlockClickedItemAction {
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    Random random = new Random(2L);
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
    int minSizeReductionPerLayer = 1;
    int maxSizeReductionPerLayer = 4;
    int numberLayers = 20;
    int roomHeight = 7;
    int initialRoomHeight = 10;
    int floorWidth = 35;
    int floorDepth = 35;
    int maxRoomXResize = 3;
    int maxRoomZResize = 3;
    Builder builder = new DefaultBuilder(this.random);

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(pos.func_177956_o(), player);
        if (!isGroundBlock) {
            return USED_ITEM;
        }
        Structure structure = this.createStructure();
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure, false);
        this.repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createStructure() {
        CompositeStructure structure = new CompositeStructure();
        CompositeStructure postComposite = new CompositeStructure();
        BlockPos offset = new BlockPos(0, 0, 0);
        int currentFloorWidth = this.floorWidth;
        int currentFloorDepth = this.floorDepth;
        for (int layer = 0; layer < this.numberLayers; ++layer) {
            int height = this.calculateRoomHeight(layer);
            if (this.hasReachedTop(currentFloorWidth = this.calculateLayerSize(currentFloorWidth), currentFloorDepth = this.calculateLayerSize(currentFloorDepth))) {
                BuildMaterial material = BuildUtils.selectWallMaterial(this.random);
                this.builder.buildTop(offset, material.getBlock(), structure);
                break;
            }
            int floorWidthDiv2 = currentFloorWidth / 2;
            int floorWidthDiv4 = currentFloorWidth / 4;
            int floorXCenter = floorWidthDiv4 + this.random.nextInt(floorWidthDiv2);
            int floorDepthDiv2 = currentFloorDepth / 2;
            int floorDepthDiv4 = currentFloorDepth / 4;
            int floorZCenter = floorDepthDiv4 + this.random.nextInt(floorDepthDiv2);
            BlockPos room1Offset = new BlockPos(0, offset.func_177956_o(), 0);
            BlockPos room1Size = new BlockPos(floorXCenter, height, floorZCenter);
            BuildMaterial material = BuildUtils.selectWallMaterial(this.random);
            Room room1 = Room.createNWRoom(room1Offset, room1Size, material);
            room1.resize(this.random.nextInt(this.maxRoomXResize), this.random.nextInt(this.maxRoomZResize));
            BlockPos room2Offset = new BlockPos(floorXCenter - 1, offset.func_177956_o(), 0);
            BlockPos room2Size = new BlockPos(currentFloorWidth - floorXCenter, height, floorZCenter);
            material = BuildUtils.selectWallMaterial(this.random);
            Room room2 = Room.createNERoom(room2Offset, room2Size, material);
            room2.resize(this.random.nextInt(this.maxRoomXResize), this.random.nextInt(this.maxRoomZResize));
            BlockPos room3Offset = new BlockPos(0, offset.func_177956_o(), floorZCenter - 1);
            BlockPos room3Size = new BlockPos(floorXCenter, height, currentFloorDepth - floorZCenter);
            material = BuildUtils.selectWallMaterial(this.random);
            Room room3 = Room.createSWRoom(room3Offset, room3Size, material);
            room3.resize(this.random.nextInt(this.maxRoomXResize), this.random.nextInt(this.maxRoomZResize));
            BlockPos room4Offset = new BlockPos(floorXCenter - 1, offset.func_177956_o(), floorZCenter - 1);
            BlockPos room4Size = new BlockPos(currentFloorWidth - floorXCenter, height, currentFloorDepth - floorZCenter);
            material = BuildUtils.selectWallMaterial(this.random);
            Room room4 = Room.createSERoom(room4Offset, room4Size, material);
            room4.resize(this.random.nextInt(this.maxRoomXResize), this.random.nextInt(this.maxRoomZResize));
            this.builder.buildRoom(room1, structure);
            this.builder.buildRoom(room2, structure);
            this.builder.buildRoom(room3, structure);
            this.builder.buildRoom(room4, structure);
            if (layer == 0) {
                BlockPos doorOffset = new BlockPos(floorXCenter - floorWidthDiv4, 0, room1.getOffset().func_177952_p());
                BuildUtils.addMainEntranceFront(structure, doorOffset);
            }
            this.builder.buildFloor(room1, structure);
            this.builder.buildFloor(room2, structure);
            this.builder.buildFloor(room3, structure);
            this.builder.buildFloor(room4, structure);
            if (this.placeStairsInRoom1(layer)) {
                this.builder.buildStairs(room1, structure, postComposite);
            } else {
                this.builder.buildStairs(room4, structure, postComposite);
            }
            for (Wall wall : room1.getInteriorWalls()) {
                this.builder.buildDoor(wall, structure);
            }
            for (Wall wall : room4.getInteriorWalls()) {
                this.builder.buildDoor(wall, structure);
            }
            for (Wall wall : room1.getExternalWalls()) {
                this.builder.buildWindow(wall, structure);
            }
            for (Wall wall : room2.getExternalWalls()) {
                this.builder.buildWindow(wall, structure);
            }
            for (Wall wall : room3.getExternalWalls()) {
                this.builder.buildWindow(wall, structure);
            }
            for (Wall wall : room4.getExternalWalls()) {
                this.builder.buildWindow(wall, structure);
            }
            this.builder.buildMobSpawner(room1, structure);
            this.builder.buildMobSpawner(room2, structure);
            this.builder.buildMobSpawner(room3, structure);
            this.builder.buildMobSpawner(room4, structure);
            offset = new BlockPos(0, offset.func_177956_o() + height, 0);
        }
        structure.add(postComposite);
        return structure;
    }

    int calculateRoomHeight(int layer) {
        if (layer == 0) {
            return this.initialRoomHeight;
        }
        return this.roomHeight;
    }

    boolean hasReachedTop(int currentFloorWidth, int currentFloorDepth) {
        if (currentFloorWidth <= 2) {
            return true;
        }
        return currentFloorDepth <= 2;
    }

    boolean placeStairsInRoom1(int layer) {
        return layer % 2 == 1;
    }

    int calculateLayerSize(int currentSize) {
        int delta = this.minSizeReductionPerLayer + this.random.nextInt(this.maxSizeReductionPerLayer - this.minSizeReductionPerLayer);
        return currentSize - delta;
    }
}

