/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.geom.WorldQueryImpl;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import bassebombecraft.world.TemplateUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CopyPasteBlocks
implements BlockClickedItemAction {
    public static final String NAME = CopyPasteBlocks.class.getSimpleName();
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    static final String MSG_COPIED = "Copied blocks.";
    static final String MSG_ILLEGAL_TRIGGER = "Illegal trigger. Click on a ground block to paste.";
    static final String MSG_RESET = "Reset captured blocks.";
    static final String MSG_REGISTERED_M1 = "Registered #1 marker. Click on another ground block to set the second marker.";
    static final String MSG_REGISTERED_M2 = "Registered #2 marker and captured blocks. Click on a ground block to paste. Click on a non-ground block to reset.";
    ParticleRenderingInfo[] infos;
    static final Structure NULL_STRUCTURE = new CompositeStructure();
    static final int FIRST_INDEX = 0;
    StaffState state = StaffState.NO_MARKERS_DEFINED;
    BlockPos firstMarker;
    BlockPos secondMarker;
    boolean isActive = false;
    int rotationDegrees;
    List<BlockDirective> capturedBlocks;
    BlockDirectivesRepository directivesRepository;
    ParticleRenderingRepository particleRepository;
    ParticleRendering firstMarkerParticle;
    ParticleRendering secondMarkerParticle;
    boolean captureOnCopy;

    public CopyPasteBlocks() {
        this.infos = ConfigUtils.createFromConfig(ModConfiguration.copyPasteBlocksParticleInfo);
        this.captureOnCopy = (Boolean)ModConfiguration.copyPasteBlocksCaptureOnCopy.get();
        this.particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        this.directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        WorldQueryImpl worldQuery = new WorldQueryImpl(player, pos);
        Structure structure = this.updateState(worldQuery);
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        this.directivesRepository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure updateState(WorldQuery worldQuery) {
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(worldQuery.getTargetBlockPosition().func_177956_o(), worldQuery.getPlayer());
        switch (this.state) {
            case NO_MARKERS_DEFINED: {
                if (!this.isLegaLFirstMarker(isGroundBlock)) {
                    return NULL_STRUCTURE;
                }
                this.state = StaffState.FIRST_MARKER_DEFINED;
                this.registerFirstMarker(worldQuery.getTargetBlockPosition(), worldQuery.getPlayer());
                PlayerUtils.sendChatMessageToPlayer(worldQuery.getPlayer(), MSG_REGISTERED_M1);
                return NULL_STRUCTURE;
            }
            case FIRST_MARKER_DEFINED: {
                if (!this.isLegaLSecondMarker(isGroundBlock, worldQuery.getTargetBlockPosition())) {
                    return NULL_STRUCTURE;
                }
                this.state = StaffState.SECOND_MARKER_DEFINED;
                this.registerSecondMarker(worldQuery.getTargetBlockPosition());
                this.captureWorldContent(worldQuery);
                PlayerUtils.sendChatMessageToPlayer(worldQuery.getPlayer(), MSG_REGISTERED_M2);
                return NULL_STRUCTURE;
            }
            case SECOND_MARKER_DEFINED: {
                if (!this.isLegalTrigger(isGroundBlock, worldQuery.getTargetBlockPosition(), worldQuery.getPlayer())) {
                    if (this.shouldReset(isGroundBlock)) {
                        this.state = StaffState.NO_MARKERS_DEFINED;
                        PlayerUtils.sendChatMessageToPlayer(worldQuery.getPlayer(), MSG_RESET);
                        this.clearRendering();
                        return NULL_STRUCTURE;
                    }
                    PlayerUtils.sendChatMessageToPlayer(worldQuery.getPlayer(), MSG_ILLEGAL_TRIGGER);
                    return NULL_STRUCTURE;
                }
                PlayerUtils.sendChatMessageToPlayer(worldQuery.getPlayer(), MSG_COPIED);
                return this.getCapturedContent(worldQuery);
            }
        }
        return NULL_STRUCTURE;
    }

    boolean isLegaLFirstMarker(boolean isGroundBlock) {
        return isGroundBlock;
    }

    boolean isLegaLSecondMarker(boolean isGroundBlock, BlockPos pos) {
        if (!isGroundBlock) {
            return false;
        }
        BlockPos candidateMarker = pos;
        return !this.firstMarker.equals((Object)candidateMarker);
    }

    boolean isLegalTrigger(boolean isGroundBlock, BlockPos trigger, PlayerEntity playerIn) {
        if (!isGroundBlock) {
            return false;
        }
        if (this.firstMarker.equals((Object)trigger)) {
            PlayerUtils.sendChatMessageToPlayer(playerIn, "First marker isn't a legal target position.");
            return false;
        }
        if (this.secondMarker.equals((Object)trigger)) {
            PlayerUtils.sendChatMessageToPlayer(playerIn, "Second marker isn't a legal target position.");
            return false;
        }
        return true;
    }

    boolean shouldReset(boolean isGroundBlock) {
        return !isGroundBlock;
    }

    void registerFirstMarker(BlockPos pos, PlayerEntity playerIn) {
        this.firstMarker = pos;
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(playerIn);
        if (playerDirection == PlayerDirection.East) {
            playerDirection = PlayerDirection.West;
        } else if (playerDirection == PlayerDirection.West) {
            playerDirection = PlayerDirection.East;
        }
        this.rotationDegrees = GeometryUtils.calculateDegreesFromPlayerDirection(playerDirection);
        this.firstMarkerParticle = DefaultParticleRendering.getInstance(pos, this.infos[0]);
        this.particleRepository.add(this.firstMarkerParticle);
    }

    void registerSecondMarker(BlockPos pos) {
        this.secondMarker = pos;
        this.secondMarkerParticle = DefaultParticleRendering.getInstance(pos, this.infos[0]);
        this.particleRepository.add(this.secondMarkerParticle);
    }

    void captureWorldContent(WorldQuery worldQuery) {
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(worldQuery.getPlayer());
        BlockPos lower = this.calculateLowerBound();
        BlockPos upper = this.calculateUpperBound();
        BlockPos captureOffset = new BlockPos((Vec3i)lower);
        BlockPos captureSize = new BlockPos(upper.func_177958_n() - lower.func_177958_n(), upper.func_177956_o() - lower.func_177956_o(), upper.func_177952_p() - lower.func_177952_p());
        if (captureSize.func_177956_o() <= 0) {
            captureSize = new BlockPos(captureSize.func_177958_n(), 1, captureSize.func_177952_p());
        }
        this.capturedBlocks = GeometryUtils.captureRectangle(captureOffset, captureSize, worldQuery);
        BlockPos translation = this.calculateTranslationVector(captureOffset, captureSize, playerDirection);
        this.capturedBlocks = GeometryUtils.translate(translation, this.capturedBlocks);
        if (!this.captureOnCopy) {
            return;
        }
        if (this.capturedBlocks.isEmpty()) {
            return;
        }
        int index = this.capturedBlocks.size();
        BlockDirective lastblock = this.capturedBlocks.get(index - 1);
        int capturedBlocksHeight = lastblock.getY();
        captureSize = captureSize.func_177982_a(0, capturedBlocksHeight, 0);
        TemplateUtils.save(worldQuery.getWorld(), captureOffset, captureSize);
    }

    BlockPos calculateLowerBound() {
        int x = 0;
        int y = 0;
        int z = 0;
        x = this.firstMarker.func_177958_n() < this.secondMarker.func_177958_n() ? this.firstMarker.func_177958_n() : this.secondMarker.func_177958_n();
        y = this.firstMarker.func_177956_o() < this.secondMarker.func_177956_o() ? this.firstMarker.func_177956_o() : this.secondMarker.func_177956_o();
        z = this.firstMarker.func_177952_p() < this.secondMarker.func_177952_p() ? this.firstMarker.func_177952_p() : this.secondMarker.func_177952_p();
        return new BlockPos(x + 1, y + 1, z + 1);
    }

    BlockPos calculateUpperBound() {
        int x = 0;
        int y = 0;
        int z = 0;
        x = this.firstMarker.func_177958_n() < this.secondMarker.func_177958_n() ? this.secondMarker.func_177958_n() : this.firstMarker.func_177958_n();
        y = this.firstMarker.func_177956_o() < this.secondMarker.func_177956_o() ? this.secondMarker.func_177956_o() : this.firstMarker.func_177956_o();
        z = this.firstMarker.func_177952_p() < this.secondMarker.func_177952_p() ? this.secondMarker.func_177952_p() : this.firstMarker.func_177952_p();
        return new BlockPos(x, y, z);
    }

    BlockPos calculateTranslationVector(BlockPos captureOffset, BlockPos captureSize, PlayerDirection playerDirection) {
        int translateX = captureOffset.func_177958_n();
        int translateY = captureOffset.func_177956_o();
        int translateZ = captureOffset.func_177952_p();
        switch (playerDirection) {
            case South: {
                return new BlockPos(translateX + captureSize.func_177958_n() - 1, translateY, translateZ);
            }
            case West: {
                return new BlockPos(translateX + captureSize.func_177958_n() - 1, translateY, translateZ + captureSize.func_177952_p() - 1);
            }
            case North: {
                return new BlockPos(translateX, translateY, translateZ + captureSize.func_177952_p() - 1);
            }
            case East: {
                return new BlockPos(translateX, translateY, translateZ);
            }
        }
        return new BlockPos(translateX, translateY, translateZ);
    }

    Structure getCapturedContent(WorldQuery worldQuery) {
        List<BlockDirective> rotatedBlocks = GeometryUtils.rotateCoordinatesAroundYAxisAtOrigin(this.rotationDegrees, this.capturedBlocks);
        return this.generateStructureForCapturedContent(rotatedBlocks, worldQuery);
    }

    Structure generateStructureForCapturedContent(List<BlockDirective> capturedBlocks, WorldQuery worldQuery) {
        BlockPos unitSize = new BlockPos(1, 1, 1);
        CompositeStructure composite = new CompositeStructure();
        for (BlockDirective directive : capturedBlocks) {
            ChildStructure child = new ChildStructure(directive.getBlockPosition(), unitSize, directive.getBlock(), directive.getState());
            composite.add(child);
        }
        return composite;
    }

    void clearRendering() {
        this.particleRepository.remove(this.firstMarkerParticle);
        this.particleRepository.remove(this.secondMarkerParticle);
    }

    static enum StaffState {
        NO_MARKERS_DEFINED,
        FIRST_MARKER_DEFINED,
        SECOND_MARKER_DEFINED;

    }
}

