/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build.tower;

import bassebombecraft.item.action.build.tower.BuildMaterial;
import bassebombecraft.item.action.build.tower.Wall;
import net.minecraft.util.math.BlockPos;

public class Room {
    BlockPos offset;
    BlockPos size;
    BuildMaterial material;
    RoomType type;
    Wall northernWall;
    Wall southernWall;
    Wall westernWall;
    Wall easternWall;

    Room(RoomType type, BlockPos offset, BlockPos size, BuildMaterial material) {
        this.type = type;
        this.offset = offset;
        this.size = size;
        this.material = material;
        this.calculateWalls();
    }

    void calculateWalls() {
        this.northernWall = Wall.createXAxisOrientedWall(this.offset, this);
        this.southernWall = Wall.createXAxisOrientedWall(this.offset.func_177982_a(0, 0, this.size.func_177952_p() - 1), this);
        this.westernWall = Wall.createZAxisOrientedWall(this.offset, this);
        this.easternWall = Wall.createZAxisOrientedWall(this.offset.func_177982_a(this.size.func_177958_n() - 1, 0, 0), this);
    }

    public void resize(int width, int depth) {
        switch (this.type) {
            case NW: {
                this.offset = this.offset.func_177982_a(-width, 0, -depth);
                this.size = this.size.func_177982_a(width, 0, depth);
                this.calculateWalls();
                return;
            }
            case NE: {
                this.offset = this.offset.func_177982_a(0, 0, -depth);
                this.size = this.size.func_177982_a(width, 0, depth);
                this.calculateWalls();
                return;
            }
            case SW: {
                this.offset = this.offset.func_177982_a(-width, 0, 0);
                this.size = this.size.func_177982_a(width, 0, depth);
                this.calculateWalls();
                return;
            }
            case SE: {
                this.offset = this.offset.func_177982_a(0, 0, 0);
                this.size = this.size.func_177982_a(width, 0, depth);
                this.calculateWalls();
                return;
            }
        }
    }

    public Wall[] getExternalWalls() {
        switch (this.type) {
            case NW: {
                return new Wall[]{this.northernWall, this.westernWall};
            }
            case NE: {
                return new Wall[]{this.northernWall, this.easternWall};
            }
            case SW: {
                return new Wall[]{this.southernWall, this.westernWall};
            }
            case SE: {
                return new Wall[]{this.southernWall, this.easternWall};
            }
        }
        return new Wall[0];
    }

    public Wall[] getInteriorWalls() {
        switch (this.type) {
            case NW: {
                return new Wall[]{this.southernWall, this.easternWall};
            }
            case NE: {
                return new Wall[]{this.southernWall, this.westernWall};
            }
            case SW: {
                return new Wall[]{this.northernWall, this.easternWall};
            }
            case SE: {
                return new Wall[]{this.northernWall, this.westernWall};
            }
        }
        return new Wall[0];
    }

    public BlockPos getSize() {
        return this.size;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public BuildMaterial getMaterial() {
        return this.material;
    }

    public static Room createNWRoom(BlockPos offset, BlockPos size, BuildMaterial material) {
        return new Room(RoomType.NW, offset, size, material);
    }

    public static Room createNERoom(BlockPos offset, BlockPos size, BuildMaterial material) {
        return new Room(RoomType.NE, offset, size, material);
    }

    public static Room createSWRoom(BlockPos offset, BlockPos size, BuildMaterial material) {
        return new Room(RoomType.SW, offset, size, material);
    }

    public static Room createSERoom(BlockPos offset, BlockPos size, BuildMaterial material) {
        return new Room(RoomType.SE, offset, size, material);
    }

    public RoomType getType() {
        return this.type;
    }

    static enum RoomType {
        NW,
        NE,
        SW,
        SE;

    }
}

