/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.entity.target.TargetedEntitiesRepository;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import bassebombecraft.player.PlayerUtils;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.naming.OperationNotSupportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class SpawnAngryParrots
implements InventoryItemActionStrategy {
    public static final String NAME = SpawnAngryParrots.class.getSimpleName();
    static final SoundEvent SOUND = SoundEvents.field_192796_et;
    final float damage;
    final double movementSpeed;

    public SpawnAngryParrots(Supplier<Integer> splDamage, Supplier<Double> splMovementSpeed) {
        this.damage = splDamage.get().intValue();
        this.movementSpeed = splMovementSpeed.get();
    }

    @Override
    public boolean applyOnlyIfSelected() {
        return true;
    }

    @Override
    public boolean shouldApplyEffect(Entity target, boolean targetIsInvoker) {
        return !targetIsInvoker;
    }

    @Override
    public void applyEffect(Entity target, World world, LivingEntity invoker) {
        if (EntityUtils.isTypeParrotEntity(target)) {
            return;
        }
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        ParrotEntity entity = (ParrotEntity)EntityType.field_200783_W.func_200721_a(world);
        entity.func_82149_j((Entity)invoker);
        entity.func_191997_m(random.nextInt(5));
        entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_193334_e).func_111128_a(this.movementSpeed);
        entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.movementSpeed);
        entity.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.damage);
        LivingEntity entityTarget = this.resolveTarget(target, (MobEntity)entity, invoker);
        AiUtils.buildParrotAi((MobEntity)entity, entityTarget, this.damage);
        entity.func_184185_a(SOUND, 0.5f, 0.4f / random.nextFloat() * 0.4f + 0.8f);
        world.func_217376_c((Entity)entity);
    }

    LivingEntity resolveTarget(Entity target, MobEntity batEntity, LivingEntity invoker) {
        if (PlayerUtils.isTypePlayerEntity((Entity)invoker)) {
            PlayerEntity player = (PlayerEntity)invoker;
            TargetedEntitiesRepository repository = BassebombeCraft.getBassebombeCraft().getTargetedEntitiesRepository();
            Optional<LivingEntity> optTarget = repository.getFirst(player);
            if (optTarget.isPresent()) {
                return optTarget.get();
            }
        }
        if (EntityUtils.isTypeLivingEntity(target)) {
            LivingEntity livingEntity = (LivingEntity)target;
            return livingEntity;
        }
        return null;
    }

    @Override
    public int getEffectRange() throws OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() throws OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }
}

