/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.mist.block.BlockMistActionStrategy;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GenericBlockSpiralFillMist
implements RightClickedItemAction {
    public static final String NAME = GenericBlockSpiralFillMist.class.getSimpleName();
    @Deprecated
    int ticksCounter = 0;
    LivingEntity entity;
    Vec3d entityLook;
    boolean isActive = false;
    BlockMistActionStrategy strategy;
    List<BlockPos> spiralCoordinates;
    int spiralCounter;
    BlockPos spiralCenter;
    BlockPos mistPosition;
    int spiralSize;

    public GenericBlockSpiralFillMist(BlockMistActionStrategy strategy) {
        this.strategy = strategy;
        this.spiralSize = (Integer)ModConfiguration.genericBlockSpiralFillMistSpiralSize.get();
        this.spiralCoordinates = GeometryUtils.calculateSpiral(this.spiralSize, this.spiralSize);
    }

    @Override
    public void onRightClick(World world, LivingEntity entity) {
        this.entity = entity;
        this.isActive = true;
        this.ticksCounter = 0;
        this.initializeMistPostition(world, entity);
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.isActive()) {
            return;
        }
        FrequencyRepository repository = BassebombeCraft.getBassebombeCraft().getFrequencyRepository();
        if (repository.isActive(3)) {
            this.render(worldIn);
        }
        if (repository.isActive(3)) {
            this.applyEffect(worldIn);
        }
        if (this.ticksCounter > this.strategy.getEffectDuration()) {
            this.isActive = false;
            this.entity = null;
            return;
        }
        ++this.ticksCounter;
    }

    boolean isActive() {
        return this.isActive;
    }

    void initializeMistPostition(World world, LivingEntity entity) {
        this.spiralCounter = this.strategy.getSpiralOffset();
        this.spiralCenter = new BlockPos((Entity)entity);
    }

    void applyEffect(World world) {
        this.strategy.applyEffectToBlock(this.mistPosition, world);
    }

    void render(World world) {
        this.updateMistPosition(world);
        ParticleRenderingRepository repository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(this.mistPosition, info);
            repository.add(particle);
        }
    }

    void updateMistPosition(World world) {
        if (this.spiralCounter >= this.spiralCoordinates.size()) {
            return;
        }
        BlockPos spiralCoord = this.spiralCoordinates.get(this.spiralCounter);
        int x = this.spiralCenter.func_177958_n() + spiralCoord.func_177958_n();
        int y = this.spiralCenter.func_177956_o();
        int z = this.spiralCenter.func_177952_p() + spiralCoord.func_177952_p();
        BlockPos groundCandidate = new BlockPos(x, y, z);
        this.mistPosition = GeometryUtils.locateGroundBlockPos(groundCandidate, 256, world);
        ++this.spiralCounter;
    }

    public String toString() {
        return super.toString() + ", strategy=" + this.strategy;
    }
}

