/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.item.action.mist.block.BlockMistActionStrategy;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MovingRainbowMist
implements BlockMistActionStrategy {
    private static final int NUMBER_COLORS = 8;
    static final boolean DONT_HARVEST = false;
    static final int EFFECT_DURATION = 200;
    static final BasicParticleType PARTICLE_TYPE = ParticleTypes.field_197597_H;
    static final int PARTICLE_NUMBER = 5;
    static final int PARTICLE_DURATION = 20;
    static final float R = 0.75f;
    static final float B = 0.75f;
    static final float G = 0.75f;
    static final double PARTICLE_SPEED = 0.075;
    static final ParticleRenderingInfo MIST = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 5, 20, 0.75f, 0.75f, 0.75f, 0.075);
    static final ParticleRenderingInfo[] INFOS = new ParticleRenderingInfo[]{MIST};
    int colorCounter = 0;

    @Override
    public void applyEffectToBlock(BlockPos target, World world) {
        ++this.colorCounter;
        BlockState blockstate = this.selectWoolColor();
        BlockDirective directive = new BlockDirective(target, blockstate.func_177230_c(), false);
        directive.setState(blockstate);
        BlockDirectivesRepository directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        directivesRepository.add(directive);
    }

    BlockState selectWoolColor() {
        int colorSelector = this.colorCounter % 8;
        switch (colorSelector) {
            case 0: {
                return Blocks.field_196558_aN.func_176223_P();
            }
            case 1: {
                return Blocks.field_196566_aV.func_176223_P();
            }
            case 2: {
                return Blocks.field_196567_aW.func_176223_P();
            }
            case 3: {
                return Blocks.field_196559_aO.func_176223_P();
            }
            case 4: {
                return Blocks.field_196561_aQ.func_176223_P();
            }
            case 5: {
                return Blocks.field_196560_aP.func_176223_P();
            }
            case 6: {
                return Blocks.field_196557_aM.func_176223_P();
            }
            case 7: {
                return Blocks.field_196570_aZ.func_176223_P();
            }
        }
        return Blocks.field_196556_aL.func_176223_P();
    }

    @Override
    public int getEffectDuration() {
        return 200;
    }

    @Override
    public int getNumberMists() {
        return 1;
    }

    @Override
    public double getMistAngle() {
        return 0.0;
    }

    @Override
    public boolean isOneShootEffect() {
        return false;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return INFOS;
    }

    @Override
    public int getSpiralOffset() {
        return 0;
    }
}

