/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.entity;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import bassebombecraft.player.PlayerUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GenericEntityMist
implements RightClickedItemAction {
    public static final String NAME = GenericEntityMist.class.getSimpleName();
    static final int INVOCATION_DIST = 4;
    @Deprecated
    int ticksCounter = 0;
    List<BlockPos> spiralCoordinates;
    Vec3d mistPos;
    LivingEntity entity;
    Vec3d entityLook;
    boolean isActive = false;
    EntityMistActionStrategy strategy;
    int spiralSize;

    public GenericEntityMist(EntityMistActionStrategy strategy) {
        this.strategy = strategy;
        this.spiralSize = (Integer)ModConfiguration.genericEntityMistSpiralSize.get();
        this.spiralCoordinates = GeometryUtils.calculateSpiral(this.spiralSize, this.spiralSize);
    }

    @Override
    public void onRightClick(World world, LivingEntity entity) {
        this.entity = entity;
        this.isActive = true;
        this.ticksCounter = 0;
        this.calculateMistPostition(world, entity);
    }

    void applyEffect(World world, LivingEntity invokingEntity) {
        int aoeRange = this.strategy.getEffectRange();
        AxisAlignedBB aabb = new AxisAlignedBB(this.mistPos.field_72450_a - (double)aoeRange, this.mistPos.field_72448_b - (double)aoeRange, this.mistPos.field_72449_c - (double)aoeRange, this.mistPos.field_72450_a + (double)aoeRange, this.mistPos.field_72448_b + (double)aoeRange, this.mistPos.field_72449_c + (double)aoeRange);
        List entities = world.func_217357_a(LivingEntity.class, aabb);
        for (LivingEntity foundEntity : entities) {
            if (PlayerUtils.hasIdenticalUniqueID((Entity)invokingEntity, (Entity)foundEntity) && !this.strategy.isEffectAppliedToInvoker()) continue;
            this.strategy.applyEffectToEntity(foundEntity, this.mistPos, invokingEntity);
            if (!this.strategy.isOneShootEffect()) continue;
            this.isActive = false;
            return;
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.isActive()) {
            return;
        }
        FrequencyRepository repository = BassebombeCraft.getBassebombeCraft().getFrequencyRepository();
        if (repository.isActive(3)) {
            this.render(worldIn);
        }
        if (repository.isActive(3)) {
            this.applyEffect(worldIn, this.entity);
        }
        if (this.ticksCounter > this.strategy.getEffectDuration()) {
            this.isActive = false;
            this.entity = null;
            return;
        }
        ++this.ticksCounter;
    }

    boolean isActive() {
        return this.isActive;
    }

    void calculateMistPostition(World world, LivingEntity entity) {
        this.entityLook = entity.func_70676_i(1.0f);
        Vec3d entityLookX4 = new Vec3d(this.entityLook.field_72450_a * 4.0, this.entityLook.field_72448_b * 4.0, this.entityLook.field_72449_c * 4.0);
        Vec3d entityPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double x = entityLookX4.field_72450_a;
        float y = entity.func_70047_e();
        double z = entityLookX4.field_72449_c;
        this.mistPos = entityPos.func_72441_c(x, (double)y, z);
    }

    void render(World world) {
        if (!this.strategy.isStationary()) {
            this.mistPos = this.mistPos.func_178787_e(this.entityLook);
        }
        ParticleRenderingRepository particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        BlockPos pos = new BlockPos(this.mistPos);
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, info);
            particleRepository.add(particle);
        }
        int spiralCounter = this.ticksCounter / 3 % this.spiralSize;
        BlockPos spiralCoord = this.spiralCoordinates.get(spiralCounter);
        BlockPos pos2 = pos.func_177982_a(spiralCoord.func_177958_n(), 0, spiralCoord.func_177952_p());
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos2, info);
            particleRepository.add(particle);
        }
    }

    public String toString() {
        return super.toString() + ", strategy=" + this.strategy;
    }
}

