/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.InventoryItemConfig;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.item.ItemUtils;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.world.WorldUtils;
import java.util.List;
import javax.annotation.Nullable;
import javax.naming.OperationNotSupportedException;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GenericInventoryItem
extends Item {
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().func_200916_a(BassebombeCraft.getItemGroup());
    InventoryItemActionStrategy strategy;
    ParticleRenderingRepository particleRepository;
    int coolDown;
    String tooltip;
    ParticleRenderingInfo[] infos;
    int range;

    public GenericInventoryItem(String name, InventoryItemConfig config, InventoryItemActionStrategy strategy) {
        super(ITEM_PROPERTIES);
        ItemUtils.doCommonItemInitialization(this, name);
        this.strategy = strategy;
        this.particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        this.infos = ConfigUtils.createFromConfig(config.particles);
        this.coolDown = (Integer)config.cooldown.get();
        this.tooltip = (String)config.tooltip.get();
        this.range = (Integer)config.range.get();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (WorldUtils.isWorldAtClientSide(worldIn)) {
            return;
        }
        if (!this.isInHotbar(itemSlot)) {
            return;
        }
        boolean shouldActivateFromOffHand = false;
        if (PlayerUtils.isTypePlayerEntity(entityIn)) {
            PlayerEntity player = (PlayerEntity)entityIn;
            shouldActivateFromOffHand = PlayerUtils.isItemHeldInOffHand(player, stack);
        }
        boolean shouldActivateFromHotbar = false;
        if (this.strategy.applyOnlyIfSelected()) {
            if (isSelected) {
                shouldActivateFromHotbar = true;
            }
        } else {
            shouldActivateFromHotbar = true;
        }
        if (!shouldActivateFromOffHand && !shouldActivateFromHotbar) {
            return;
        }
        if (!EntityUtils.isTypeLivingEntity(entityIn)) {
            return;
        }
        if (!PlayerUtils.isTypePlayerEntity(entityIn)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return;
        }
        CooldownTracker tracker = player.func_184811_cZ();
        tracker.func_185145_a((Item)this, this.coolDown);
        BassebombeCraft.getProxy().postItemUsage(this.getRegistryName().toString(), player.func_146103_bH().getName());
        this.applyEffect(worldIn, (LivingEntity)entityIn);
    }

    boolean isInHotbar(int itemSlot) {
        if (itemSlot < 0) {
            return false;
        }
        return itemSlot <= 8;
    }

    void applyEffect(World world, LivingEntity invokingEntity) {
        int aoeRange = this.getRange();
        AxisAlignedBB aabb = new AxisAlignedBB(invokingEntity.field_70165_t - (double)aoeRange, invokingEntity.field_70163_u - (double)aoeRange, invokingEntity.field_70161_v - (double)aoeRange, invokingEntity.field_70165_t + (double)aoeRange, invokingEntity.field_70163_u + (double)aoeRange, invokingEntity.field_70161_v + (double)aoeRange);
        List entities = world.func_217357_a(LivingEntity.class, aabb);
        for (LivingEntity foundEntity : entities) {
            boolean isInvoker;
            if (!this.strategy.shouldApplyEffect((Entity)foundEntity, isInvoker = PlayerUtils.hasIdenticalUniqueID((Entity)invokingEntity, (Entity)foundEntity))) continue;
            this.strategy.applyEffect((Entity)foundEntity, world, invokingEntity);
            this.renderEffect(foundEntity.func_174791_d());
        }
    }

    void renderEffect(Vec3d position) {
        BlockPos pos = new BlockPos(position);
        for (ParticleRenderingInfo info : this.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, info);
            this.particleRepository.add(particle);
        }
    }

    ParticleRenderingInfo[] getRenderingInfos() {
        if (this.infos != null) {
            return this.infos;
        }
        try {
            return this.strategy.getRenderingInfos();
        }
        catch (OperationNotSupportedException e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            return null;
        }
    }

    int getRange() {
        if (this.range != Integer.MIN_VALUE) {
            return this.range;
        }
        try {
            return this.strategy.getEffectRange();
        }
        catch (OperationNotSupportedException e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            return Integer.MIN_VALUE;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent text = new TranslationTextComponent(TextFormatting.GREEN + this.tooltip, new Object[0]);
        tooltip.add((ITextComponent)text);
    }

    public int getCoolDown() {
        return this.coolDown;
    }
}

