/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.projectile.action.NullAction;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.world.WorldUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class GenericEggProjectile
extends ProjectileItemEntity {
    static final ProjectileAction NULL_BEHAVIOUR = new NullAction();
    static final float R = 1.0f;
    static final float G = 1.0f;
    static final float B = 1.0f;
    static final int PARTICLE_NUMBER = 5;
    static final BasicParticleType PARTICLE_TYPE = ParticleTypes.field_197590_A;
    static final int PARTICLE_DURATION = 20;
    static final double PARTICLE_SPEED = 0.3;
    static final ParticleRenderingInfo PARTICLE_INFO = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 5, 20, 1.0f, 1.0f, 1.0f, 0.3);
    public static final String PROJECTILE_NAME = GenericEggProjectile.class.getSimpleName();
    ProjectileAction behaviour = NULL_BEHAVIOUR;

    public GenericEggProjectile(EntityType<? extends ProjectileItemEntity> type, World world) {
        super(type, world);
        this.setBehaviour(NULL_BEHAVIOUR);
    }

    public GenericEggProjectile(World world, LivingEntity entity, ProjectileAction behaviour) {
        super(EntityType.field_200751_aq, entity, world);
        this.setBehaviour(behaviour);
    }

    public void setBehaviour(ProjectileAction behaviour) {
        this.behaviour = behaviour;
    }

    protected void func_70184_a(RayTraceResult result) {
        World world = this.func_130014_f_();
        if (WorldUtils.isWorldAtClientSide(world)) {
            return;
        }
        try {
            this.behaviour.execute((ThrowableEntity)this, world, result);
            ParticleRendering particle = DefaultParticleRendering.getInstance(this.func_180425_c(), PARTICLE_INFO);
            ParticleRenderingRepository repository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
            repository.add(particle);
            this.func_70106_y();
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        try {
            ParticleRendering particle = DefaultParticleRendering.getInstance(this.func_180425_c(), PARTICLE_INFO);
            ParticleRenderingRepository repository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
            repository.add(particle);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    protected Item func_213885_i() {
        return Items.field_151110_aK;
    }
}

