/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.projectile.ProjectileUtils;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class DigMobHole
implements ProjectileAction {
    public static final String NAME = DigMobHole.class.getSimpleName();
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
    final int noHitHoleDepth = (Integer)ModConfiguration.digMobHoleNoHitHoleDepth.get();
    final int noHitholeHeight = (Integer)ModConfiguration.digMobHoleNoHitHoleHeight.get();
    final int noHitholeWidth = (Integer)ModConfiguration.digMobHoleNoHitHoleWidth.get();
    final int holeHeightExpansion = (Integer)ModConfiguration.digMobHoleHeightExpansion.get();

    @Override
    public void execute(ThrowableEntity projectile, World world, RayTraceResult result) {
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            BlockPos offset = BlockUtils.calculatePosition(blockResult);
            CompositeStructure composite = new CompositeStructure();
            this.createVerticalStructure(composite);
            PlayerDirection playerDirection = PlayerDirection.South;
            List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, composite);
            this.repository.addAll(directives);
            return;
        }
        if (!ProjectileUtils.isEntityHit(result)) {
            return;
        }
        if (!ProjectileUtils.isTypeEntityRayTraceResult(result)) {
            return;
        }
        Entity entity = ((EntityRayTraceResult)result).func_216348_a();
        AxisAlignedBB aabb = entity.func_174813_aQ();
        BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b - (double)this.holeHeightExpansion, aabb.field_72339_c);
        BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).forEach(pos -> this.registerBlockToDig(aabb, (BlockPos)pos));
    }

    void registerBlockToDig(AxisAlignedBB aabb, BlockPos pos) {
        double translateY = aabb.field_72337_e - aabb.field_72338_b;
        BlockPos tranlatedPos = pos.func_177963_a(0.0, -translateY, 0.0);
        BlockDirective directive = new BlockDirective(tranlatedPos, Blocks.field_150350_a, false);
        this.repository.add(directive);
    }

    void createVerticalStructure(CompositeStructure composite) {
        BlockPos offset = new BlockPos(0, -this.noHitHoleDepth, 0);
        BlockPos size = new BlockPos(this.noHitholeWidth, this.noHitholeHeight, this.noHitHoleDepth);
        composite.add(ChildStructure.createAirStructure(offset, size));
    }
}

