/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.ModConstants;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.BoundingBoxRenderer;
import bassebombecraft.rendering.EntityRenderer;
import bassebombecraft.rendering.HitByRayTraceBoundingBoxRenderer;
import bassebombecraft.rendering.RenderingInfo;
import bassebombecraft.rendering.RenderingUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class DefaultBuildMineRenderer
implements EntityRenderer {
    static final float BILLBOARD_Y_DISP = -1.5f;
    static final BoundingBoxRenderer aabbRenderer = new HitByRayTraceBoundingBoxRenderer();

    @Override
    public void render(LivingEntity entity, RenderingInfo info) {
        if (!PlayerUtils.isTypePlayerEntity((Entity)entity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        RayTraceResult result = info.getResult();
        if (!info.isRayTraceResultDefined()) {
            return;
        }
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, info.getPartialTicks());
        BlockPos blockPos = blockResult.func_216350_a();
        AxisAlignedBB aabb = new AxisAlignedBB(blockPos);
        aabbRenderer.render(aabb, info);
        Direction direction = blockResult.func_216354_b();
        Vec3d aabbCenter = aabb.func_189972_c();
        Vec3d aabb2 = aabbCenter.func_72441_c(0.0, -1.5, 0.0);
        switch (direction) {
            case UP: {
                String message = "> Click on a GROUND block to excavate ENTRACE";
                RenderingUtils.renderTextBillboard(playerPos, aabb2, message, ModConstants.TEXT_BILLBOARD_ROTATION, 0xC0C000);
                break;
            }
            case DOWN: {
                break;
            }
            case EAST: 
            case NORTH: 
            case SOUTH: 
            case WEST: {
                String message = "> Click on a WALL block to excavate ROOM";
                RenderingUtils.renderTextBillboard(playerPos, aabb2, message, ModConstants.TEXT_BILLBOARD_ROTATION, 0xC0C000);
                break;
            }
        }
    }
}

