/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.EntityRenderer;
import bassebombecraft.rendering.RenderingInfo;
import bassebombecraft.rendering.RenderingUtils;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class DefaultCharmedInfoRenderer
implements EntityRenderer {
    static final String CHARMED_LABEL = "CHARMED";

    @Override
    public void render(LivingEntity entity, RenderingInfo info) {
        if (!PlayerUtils.isTypePlayerEntity((Entity)entity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, info.getPartialTicks());
        Vec3d renderPos = RenderingUtils.getRenderPos();
        Vec3d translation = playerPos.func_178788_d(renderPos);
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        Collection<CharmedMob> charmedMobs = repository.get();
        int charmedSize = charmedMobs.size();
        Vec3d textTranslation = new Vec3d(5.0, 1.0, 4.0);
        RenderingUtils.renderHudTextBillboard(translation, textTranslation, CHARMED_LABEL);
        RenderingUtils.renderHudTextBillboard(translation, textTranslation.func_72441_c(0.0, -0.25, 0.0), "Number charmed: " + charmedSize);
        AtomicInteger count = new AtomicInteger();
        charmedMobs.forEach(c -> {
            int counter = count.incrementAndGet();
            if (counter > 7) {
                return;
            }
            int disp = 1 + counter;
            LivingEntity charmedEntity = c.getEntity();
            String memberName = charmedEntity.func_200200_C_().func_150261_e();
            int duration = c.getDuration();
            String text = "Mob: " + memberName + ", Charm duration: " + duration;
            RenderingUtils.renderHudTextBillboard(translation, textTranslation.func_72441_c(0.0, -0.25 * (double)disp, 0.0), text);
        });
    }
}

