/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.DefaultBoundingBoxEntityRenderer;
import bassebombecraft.rendering.DefaultTargetEntityRenderer;
import bassebombecraft.rendering.EntityRenderer;
import bassebombecraft.rendering.RenderingInfo;
import bassebombecraft.rendering.RenderingUtils;
import java.util.Collection;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class DefaultCharmedRenderer
implements EntityRenderer {
    static final int BILLBOARD_ANGLE = 0;
    static final Vector4f BILLBOARD_ROTATION = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    static final String CHARMED_LABEL = "Charmed";
    static final EntityRenderer boundingBoxRenderer = new DefaultBoundingBoxEntityRenderer();
    static final EntityRenderer targetRenderer = new DefaultTargetEntityRenderer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(LivingEntity entity, RenderingInfo info) {
        Collection<CharmedMob> entities;
        if (!PlayerUtils.isTypePlayerEntity((Entity)entity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, info.getPartialTicks());
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        Collection<CharmedMob> collection = entities = repository.get();
        synchronized (collection) {
            for (CharmedMob charmedMob : entities) {
                this.renderTeamEntity(charmedMob, playerPos, info);
            }
        }
    }

    void renderTeamEntity(CharmedMob charmedMob, Vec3d playerPos, RenderingInfo info) {
        LivingEntity entity = charmedMob.getEntity();
        Vec3d entityPos = entity.func_174813_aQ().func_189972_c();
        RenderingUtils.renderTriangleBillboard(playerPos, entityPos, BILLBOARD_ROTATION);
        RenderingUtils.renderTextBillboard(playerPos, entityPos, CHARMED_LABEL, ModConstants.TEXT_BILLBOARD_ROTATION);
        boundingBoxRenderer.render(entity, info);
        targetRenderer.render(entity, info);
    }
}

