/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.ModConstants;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.BoundingBoxRenderer;
import bassebombecraft.rendering.EntityRenderer;
import bassebombecraft.rendering.RenderingInfo;
import bassebombecraft.rendering.RenderingUtils;
import bassebombecraft.rendering.WireframeBoundingBoxRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DefaultLookAtBlockRenderer
implements EntityRenderer {
    static final BoundingBoxRenderer aabbRenderer = new WireframeBoundingBoxRenderer();

    @Override
    public void render(LivingEntity entity, RenderingInfo info) {
        if (!PlayerUtils.isTypePlayerEntity((Entity)entity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        RayTraceResult result = info.getResult();
        if (!info.isRayTraceResultDefined()) {
            return;
        }
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, info.getPartialTicks());
        BlockPos blockPos = blockResult.func_216350_a();
        AxisAlignedBB aabb = new AxisAlignedBB(blockPos);
        World world = player.field_70170_p;
        BlockState blockstate = world.func_180495_p(blockPos);
        String message = blockstate.func_177230_c().func_200291_n().func_150261_e();
        aabbRenderer.render(aabb, info);
        Vec3d aabbCenter = aabb.func_189972_c();
        RenderingUtils.renderTextBillboard(playerPos, aabbCenter.func_72441_c(0.0, -2.0, 0.0), message, ModConstants.TEXT_BILLBOARD_ROTATION);
        message = aabbCenter.toString();
        RenderingUtils.renderTextBillboard(playerPos, aabbCenter.func_72441_c(0.0, -2.25, 0.0), message, ModConstants.TEXT_BILLBOARD_ROTATION);
    }
}

