/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.RenderingInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.RayTraceResult;

public class DefaultRenderingInfo
implements RenderingInfo {
    final float partialTicks;
    final double rveModifiedX;
    final double rveModifiedY;
    final double rveModifiedZ;
    RayTraceResult result;

    public DefaultRenderingInfo(float partialTicks) {
        this.partialTicks = partialTicks;
        Entity rve = BassebombeCraft.getMincraft().func_175606_aa();
        this.rveModifiedX = rve.field_70142_S + (rve.field_70165_t - rve.field_70142_S) * (double)partialTicks;
        this.rveModifiedY = rve.field_70137_T + (rve.field_70163_u - rve.field_70137_T) * (double)partialTicks;
        this.rveModifiedZ = rve.field_70136_U + (rve.field_70161_v - rve.field_70136_U) * (double)partialTicks;
    }

    public DefaultRenderingInfo(float partialTicks, RayTraceResult result) {
        this(partialTicks);
        this.result = result;
    }

    @Override
    public double getRveTranslatedViewX() {
        return -this.rveModifiedX;
    }

    @Override
    public double getRveTranslatedViewY() {
        return -this.rveModifiedY;
    }

    @Override
    public double getRveTranslatedViewYOffsetWithPlayerEyeHeight() {
        PlayerEntity player = PlayerUtils.getPlayer();
        return this.getRveTranslatedViewY() - (double)player.func_70047_e();
    }

    @Override
    public double getRveTranslatedViewZ() {
        return -this.rveModifiedZ;
    }

    @Override
    public float getPartialTicks() {
        return this.partialTicks;
    }

    @Override
    public RayTraceResult getResult() {
        return this.result;
    }

    @Override
    public boolean isRayTraceResultDefined() {
        return this.result != null;
    }

    public static RenderingInfo getInstance(float partialTicks) {
        return new DefaultRenderingInfo(partialTicks);
    }

    public static RenderingInfo getInstance(float partialTicks, RayTraceResult result) {
        return new DefaultRenderingInfo(partialTicks, result);
    }
}

