/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.DefaultTargetEntityRenderer;
import bassebombecraft.rendering.EntityRenderer;
import bassebombecraft.rendering.RenderingInfo;
import bassebombecraft.rendering.RenderingUtils;
import java.util.Collection;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class DefaultTeamRenderer
implements EntityRenderer {
    static final int BILLBOARD_ANGLE = 0;
    static final Vector4f BILLBOARD_ROTATION = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    static final String TEAM_LABEL = "Team";
    static final EntityRenderer targetRenderer = new DefaultTargetEntityRenderer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(LivingEntity entity, RenderingInfo info) {
        Collection<LivingEntity> entities;
        if (!PlayerUtils.isTypePlayerEntity((Entity)entity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, info.getPartialTicks());
        TeamRepository repository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
        Collection<LivingEntity> collection = entities = repository.get(player);
        synchronized (collection) {
            for (LivingEntity teamEntity : entities) {
                this.renderTeamEntity(teamEntity, playerPos, info);
            }
        }
    }

    void renderTeamEntity(LivingEntity entity, Vec3d playerPos, RenderingInfo info) {
        Vec3d entityPos = entity.func_174813_aQ().func_189972_c();
        RenderingUtils.renderTriangleBillboard(playerPos, entityPos, BILLBOARD_ROTATION);
        RenderingUtils.renderTextBillboard(playerPos, entityPos, TEAM_LABEL, ModConstants.TEXT_BILLBOARD_ROTATION);
        entityPos = entityPos.func_72441_c(0.0, -0.25, 0.0);
        RenderingUtils.renderTextBillboard(playerPos, entityPos, AiUtils.getFirstRunningAiGoalName(entity), ModConstants.TEXT_BILLBOARD_ROTATION);
        entityPos = entityPos.func_72441_c(0.0, -0.25, 0.0);
        RenderingUtils.renderTextBillboard(playerPos, entityPos, AiUtils.getFirstRunningAiTargetGoalName(entity), ModConstants.TEXT_BILLBOARD_ROTATION);
        targetRenderer.render(entity, info);
    }
}

