/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.rendering;

import bassebombecraft.ModConstants;
import com.mojang.blaze3d.platform.GlStateManager;
import java.time.Instant;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RenderingUtils {
    public static Vec3d getRenderPos() {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double renderPosX = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRendererManager.class, (Object)renderManager, (String)"field_78725_b");
        double renderPosY = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRendererManager.class, (Object)renderManager, (String)"field_78726_c");
        double renderPosZ = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRendererManager.class, (Object)renderManager, (String)"field_78723_d");
        Vec3d renderPos = new Vec3d(renderPosX, renderPosY, renderPosZ);
        return renderPos;
    }

    public static void prepareSimpleRendering(double x, double y, double z) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.disableTexture();
    }

    public static void completeSimpleRendering() {
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    public static void setupBillboardRotation() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager renderManager = mc.func_175598_ae();
        GlStateManager.rotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static void setupBillboardRotationV2() {
        Minecraft mc = Minecraft.func_71410_x();
        Entity rve = mc.func_175606_aa();
        GlStateManager.rotatef((float)(-rve.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)rve.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static void resetBillboardRendering() {
        GlStateManager.popMatrix();
        GlStateManager.enableTexture();
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
    }

    public static void setupBillboardRendering() {
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.disableTexture();
        GlStateManager.disableDepthTest();
    }

    public static void renderLineBillboard(Vec3d playerPos, Vec3d entityPos, Vec3d targetPos) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(targetPos.field_72450_a - entityPos.field_72450_a, targetPos.field_72448_b - entityPos.field_72448_b, targetPos.field_72449_c - entityPos.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderRectangleBillboard(Vec3d playerPos, Vec3d entityPos) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(-0.5, -0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, -0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, -0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, -0.5, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderTriangleBillboard(Vec3d playerPos, Vec3d entityPos, Vector4f rotation) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        GlStateManager.rotatef((float)rotation.w, (float)rotation.x, (float)rotation.y, (float)rotation.z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(-0.5, (double)-0.289f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, (double)-0.289f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, (double)-0.289f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, (double)0.577f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, (double)0.577f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, (double)-0.289f, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderDebugBillboard(Vec3d playerPos, Vec3d entityPos) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.color3f((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(1.0, 0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
        RenderingUtils.setupBillboardRendering();
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.color3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        tessellator = Tessellator.func_178181_a();
        bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, 1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
        RenderingUtils.setupBillboardRendering();
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.color3f((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        tessellator = Tessellator.func_178181_a();
        bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, 0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderTextBillboard(Vec3d playerPos, Vec3d entityPos, String text, Vector4f rotation) {
        RenderingUtils.renderTextBillboard(playerPos, entityPos, text, rotation, 49152);
    }

    public static void renderTextBillboard(Vec3d playerPos, Vec3d entityPos, String text, Vector4f rotation, int textColor) {
        RenderingUtils.setupBillboardRendering();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.enableTexture();
        GlStateManager.translated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        GlStateManager.scalef((float)0.02f, (float)0.02f, (float)0.02f);
        GlStateManager.rotatef((float)rotation.w, (float)rotation.x, (float)rotation.y, (float)rotation.z);
        mc.field_71466_p.func_211126_b(text, 0.0f, 0.0f, textColor);
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderTextBillboardV2(Vec3d translation, String text, Vector4f rotation) {
        RenderingUtils.setupBillboardRendering();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.enableTexture();
        GlStateManager.translated((double)translation.field_72450_a, (double)translation.field_72448_b, (double)translation.field_72449_c);
        RenderingUtils.setupBillboardRotation();
        GlStateManager.scalef((float)0.02f, (float)0.02f, (float)0.02f);
        GlStateManager.rotatef((float)rotation.w, (float)rotation.x, (float)rotation.y, (float)rotation.z);
        mc.field_71466_p.func_211126_b(text, 0.0f, 0.0f, 49152);
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderHudTextBillboard(Vec3d cameraTranslation, Vec3d textTranslation, String text) {
        RenderingUtils.setupBillboardRendering();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.enableTexture();
        GlStateManager.translated((double)cameraTranslation.field_72450_a, (double)cameraTranslation.field_72448_b, (double)cameraTranslation.field_72449_c);
        RenderingUtils.setupBillboardRotation();
        GlStateManager.translated((double)textTranslation.field_72450_a, (double)textTranslation.field_72448_b, (double)textTranslation.field_72449_c);
        GlStateManager.scalef((float)0.02f, (float)0.02f, (float)0.02f);
        GlStateManager.rotatef((float)ModConstants.TEXT_BILLBOARD_ROTATION.w, (float)ModConstants.TEXT_BILLBOARD_ROTATION.x, (float)ModConstants.TEXT_BILLBOARD_ROTATION.y, (float)ModConstants.TEXT_BILLBOARD_ROTATION.z);
        mc.field_71466_p.func_211126_b(text, 0.0f, 0.0f, 49152);
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderRotatedTextBillboard(Vec3d cameraTranslation, Vector4f rotation, String text) {
        RenderingUtils.setupBillboardRendering();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.enableTexture();
        GlStateManager.rotatef((float)rotation.w, (float)rotation.x, (float)rotation.y, (float)rotation.z);
        GlStateManager.translated((double)cameraTranslation.field_72450_a, (double)cameraTranslation.field_72448_b, (double)cameraTranslation.field_72449_c);
        GlStateManager.rotatef((float)rotation.w, (float)(-rotation.x), (float)(-rotation.y), (float)(-rotation.z));
        RenderingUtils.setupBillboardRotation();
        GlStateManager.scalef((float)0.02f, (float)0.02f, (float)0.02f);
        GlStateManager.rotatef((float)ModConstants.TEXT_BILLBOARD_ROTATION.w, (float)ModConstants.TEXT_BILLBOARD_ROTATION.x, (float)ModConstants.TEXT_BILLBOARD_ROTATION.y, (float)ModConstants.TEXT_BILLBOARD_ROTATION.z);
        mc.field_71466_p.func_211126_b(text, 0.0f, 0.0f, 49152);
        RenderingUtils.resetBillboardRendering();
    }

    public static void renderWireframeBox(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBox(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBoxTop(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBoxBottom(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBoxNorth(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBoxSouth(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBoxEast(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderSolidBoxWest(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderLine(Vec3d start, Vec3d end) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static double oscillate(double min, double max) {
        long time = Instant.now().toEpochMilli() / 10L;
        return min + (Math.sin(Math.toRadians(time)) + 1.0) / 2.0 * (max - min);
    }

    public static double oscillate(double time, double min, double max) {
        return min + (Math.sin(Math.toRadians(time)) + 1.0) / 2.0 * (max - min);
    }
}

