/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.structure;

import bassebombecraft.geom.BlockDirective;
import bassebombecraft.structure.Structure;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;

public class ChildStructure
implements Structure {
    static final Structure[] EMPTY_CHILDREN = new Structure[0];
    BlockPos offset;
    BlockPos size;
    Block block;
    BlockState state;

    public ChildStructure(BlockPos offset, BlockPos size) {
        this(offset, size, Blocks.field_150350_a);
    }

    @Deprecated
    public ChildStructure(BlockDirective offset, BlockDirective size) {
        this(offset, size, Blocks.field_150350_a);
    }

    @Deprecated
    public ChildStructure(BlockDirective offset, BlockDirective size, Block block) {
        this.offset = new BlockPos(offset.getX(), offset.getY(), offset.getZ());
        this.size = new BlockPos(size.getX(), size.getY(), size.getZ());
        this.block = block;
    }

    public ChildStructure(BlockPos offset, BlockPos size, Block block) {
        this.offset = offset;
        this.size = size;
        this.block = block;
    }

    @Deprecated
    public ChildStructure(BlockDirective offset, BlockDirective size, Block block, BlockState state) {
        this.offset = new BlockPos(offset.getX(), offset.getY(), offset.getZ());
        this.size = new BlockPos(size.getX(), size.getY(), size.getZ());
        this.block = block;
        this.state = state;
    }

    public ChildStructure(BlockPos offset, BlockPos size, Block block, BlockState state) {
        this.offset = offset;
        this.size = size;
        this.block = block;
        this.state = state;
    }

    @Override
    public int getSizeX() {
        return this.size.func_177958_n();
    }

    @Override
    public int getSizeY() {
        return this.size.func_177956_o();
    }

    @Override
    public int getSizeZ() {
        return this.size.func_177952_p();
    }

    @Override
    public int getOffsetX() {
        return this.offset.func_177958_n();
    }

    @Override
    public int getOffsetY() {
        return this.offset.func_177956_o();
    }

    @Override
    public int getOffsetZ() {
        return this.offset.func_177952_p();
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        if (this.state != null) {
            return this.state;
        }
        return this.block.func_176223_P();
    }

    @Override
    public final boolean isComposite() {
        return false;
    }

    @Override
    public final Structure[] getChildren() {
        return EMPTY_CHILDREN;
    }

    @Override
    public void add(Structure child) {
        throw new UnsupportedOperationException("Add child structure is not supported for child structure.");
    }

    public static Structure createAirStructure(BlockDirective offset, BlockDirective size) {
        return new ChildStructure(offset, size);
    }

    public static Structure createAirStructure(BlockPos offset, BlockPos size) {
        return new ChildStructure(offset, size);
    }

    public static Structure createWaterStructure(BlockDirective offset, BlockDirective size) {
        return new ChildStructure(offset, size, Blocks.field_150355_j);
    }

    public static Structure createWaterStructure(BlockPos offset, BlockPos size) {
        return new ChildStructure(offset, size, Blocks.field_150355_j);
    }

    public static Structure createIceStructure(BlockDirective offset, BlockDirective size) {
        return new ChildStructure(offset, size, Blocks.field_150432_aD);
    }

    public static Structure createIceStructure(BlockPos offset, BlockPos size) {
        return new ChildStructure(offset, size, Blocks.field_150432_aD);
    }

    public static Structure createWoodStructure(BlockDirective offset, BlockDirective size) {
        return new ChildStructure(offset, size, Blocks.field_196662_n);
    }

    public static Structure createOakFenceStructure(BlockPos offset, BlockPos size) {
        return new ChildStructure(offset, size, Blocks.field_180407_aO);
    }

    @Deprecated
    public static Structure createTorchStructure(BlockDirective offset, BlockDirective size) {
        return new ChildStructure(offset, size, Blocks.field_150478_aa);
    }

    public static Structure createTorchStructure(BlockPos offset, BlockPos size) {
        return new ChildStructure(offset, size, Blocks.field_150478_aa);
    }
}

