/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.world;

import bassebombecraft.config.StructureInfo;
import bassebombecraft.world.TemplateUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.common.IWorldGenerator;

public class RandomModStructuresGenerator
implements IWorldGenerator {
    static final String CONFIG_KEY = RandomModStructuresGenerator.class.getSimpleName();
    List<StructureInfo> infos;
    boolean enabled;

    public void generate(Random random, int chunkX, int chunkZ, World world, ChunkGenerator chunkGenerator, AbstractChunkProvider chunkProvider) {
        if (!this.enabled) {
            return;
        }
        if (this.infos == null) {
            return;
        }
        if (this.infos.isEmpty()) {
            return;
        }
        int index = random.nextInt(this.infos.size());
        StructureInfo info = this.infos.get(index);
        if (random.nextDouble() > info.getSpawnRate()) {
            return;
        }
        if (!this.generateInThisDimension(world, info)) {
            return;
        }
        if (!this.shouldSpawnInBiome(chunkX, chunkZ, world, info)) {
            return;
        }
        this.generateStructure(random, chunkX, chunkZ, world, info);
    }

    boolean shouldSpawnInBiome(int chunkX, int chunkZ, World world, StructureInfo info) {
        String biome = info.getBiome();
        if (biome == null) {
            return true;
        }
        if (biome.isEmpty()) {
            return true;
        }
        if (biome.equalsIgnoreCase("any")) {
            return true;
        }
        Biome currentBiome = world.func_180494_b(new BlockPos(chunkX, 0, chunkZ));
        String name = currentBiome.func_201856_r().func_222352_a();
        return biome.equalsIgnoreCase(name);
    }

    boolean generateInThisDimension(World world, StructureInfo info) {
        Dimension dimension = world.func_201675_m();
        return dimension instanceof OverworldDimension;
    }

    void generateStructure(Random random, int chunkX, int chunkZ, World world, StructureInfo info) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
        BlockPos basePos = new BlockPos(x, y, z);
        String structureName = "bassebombecraft:" + info.getName();
        TemplateUtils.load(world, structureName, basePos);
    }
}

