/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.block;

import bassebombecraft.block.BlockUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQueryImpl;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ProcessBlockDirectivesEventListener {
    static final float R = 1.0f;
    static final float G = 1.0f;
    static final float B = 1.0f;
    static final int PARTICLE_NUMBER = 5;
    static final EnumParticleTypes PARTICLE_TYPE = EnumParticleTypes.SPELL_INSTANT;
    static final int PARTICLE_DURATION = 20;
    static final double PARTICLE_SPEED = 3.0;
    static final ParticleRenderingInfo PARTICLE_INFO = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 5, 20, 1.0f, 1.0f, 1.0f, 3.0);
    static final int BLOCKS_PER_TICK = 3;
    static final BlockPos NULL_POSITION = null;
    BlockDirectivesRepository directivesRepository;
    ParticleRenderingRepository particleRepository;
    Random random = new Random();

    public ProcessBlockDirectivesEventListener(BlockDirectivesRepository directivesRepository, ParticleRenderingRepository particleRepository) {
        this.directivesRepository = directivesRepository;
        this.particleRepository = particleRepository;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws Exception {
        if (!this.directivesRepository.containsDirectives()) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        WorldQueryImpl worldQuery = new WorldQueryImpl(player, NULL_POSITION);
        for (int i = 0; i < 3; ++i) {
            this.processDirective(world, worldQuery);
        }
    }

    void processDirective(World world, WorldQueryImpl worldQuery) throws Exception {
        if (!this.directivesRepository.containsDirectives()) {
            return;
        }
        BlockDirective directive = this.directivesRepository.getNext();
        IBlockState currentState = world.func_180495_p(directive.getBlockPosition());
        if (currentState.equals(directive.getState())) {
            this.processDirective(world, worldQuery);
            return;
        }
        BlockUtils.createBlock(directive, worldQuery);
        BlockPos pos = directive.getBlockPosition();
        ParticleRendering particle = DefaultParticleRendering.getInstance(pos, PARTICLE_INFO);
        this.particleRepository.add(particle);
    }
}

