/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CharmedMobEventListener {
    static final float R = 1.0f;
    static final float G = 1.0f;
    static final float B = 1.0f;
    static final int PARTICLE_NUMBER = 1;
    static final EnumParticleTypes PARTICLE_TYPE = EnumParticleTypes.HEART;
    static final int PARTICLE_DURATION = 20;
    static final double PARTICLE_SPEED = 0.3;
    static final ParticleRenderingInfo PARTICLE_INFO = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 1, 20, 1.0f, 1.0f, 1.0f, 0.3);
    static final int SPAWN_PARTICLES_FREQUENCY = 40;
    int ticksCounter = 0;
    CharmedMobsRepository repository;
    ParticleRenderingRepository particleRepository;

    public CharmedMobEventListener(CharmedMobsRepository repository, ParticleRenderingRepository particleRepository) {
        this.repository = repository;
        this.particleRepository = particleRepository;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (!(event.entityLiving instanceof EntityLiving)) {
            return;
        }
        EntityLiving entityLiving = (EntityLiving)EntityLiving.class.cast(event.entityLiving);
        if (!this.repository.contains(entityLiving)) {
            return;
        }
        this.repository.update(entityLiving);
        if (this.ticksCounter % 40 == 0) {
            BlockPos pos = event.entityLiving.func_180425_c();
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, PARTICLE_INFO);
            this.particleRepository.add(particle);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (!(event.entityLiving instanceof EntityLiving)) {
            return;
        }
        EntityLiving entityLiving = (EntityLiving)EntityLiving.class.cast(event.entityLiving);
        this.repository.remove(entityLiving);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ++this.ticksCounter;
    }
}

