/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultParticleRenderingRepository
implements ParticleRenderingRepository {
    Set<ParticleRendering> particles = Collections.synchronizedSet(new HashSet());

    @Override
    public void add(ParticleRendering particle) {
        if (this.particles.contains(particle)) {
            return;
        }
        this.particles.add(particle);
    }

    @Override
    public void remove(ParticleRendering particle) {
        this.particles.remove(particle);
    }

    @Override
    public ParticleRendering[] getParticles() {
        ParticleRendering[] array = new ParticleRendering[this.particles.size()];
        return this.particles.toArray(array);
    }

    @Override
    public void clear() {
        this.particles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateParticleDuration() {
        Set<ParticleRendering> set = this.particles;
        synchronized (set) {
            Iterator<ParticleRendering> it = this.particles.iterator();
            while (it.hasNext()) {
                ParticleRendering particle = it.next();
                particle.updateDuration();
                if (!particle.isExpired()) continue;
                it.remove();
            }
        }
    }

    public static ParticleRenderingRepository getInstance() {
        return new DefaultParticleRenderingRepository();
    }
}

